/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.math.Function;

public class CoordinateFrame {
    double min;
    double max;

    public CoordinateFrame(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getRange() {
        return this.max - this.min;
    }

    public boolean contains(double d) {
        return d >= this.min && d <= this.max;
    }

    public String toString() {
        return "min=" + this.min + ", max=" + this.max;
    }

    public double transform(double d, CoordinateFrame coordinateFrame) {
        if (this.contains(d)) {
            return new Function.LinearFunction(this.getMin(), this.getMax(), coordinateFrame.getMin(), coordinateFrame.getMax()).evaluate(d);
        }
        throw new RuntimeException("Model frame doesn't contain value: " + d + ", sourceFrame=" + this);
    }
}

