/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.Command;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.piccolophet.PiccoloModule;
import edu.colorado.phet.quantumwaveinterference.QWIOptionsMenu;
import edu.colorado.phet.quantumwaveinterference.controls.QWIControlPanel;
import edu.colorado.phet.quantumwaveinterference.controls.ResolutionControl;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.DetectorSet;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.potentials.HorizontalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.potentials.RectangularPotential;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RectangularPotentialGraphic;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;

public class QWIModule
extends PiccoloModule {
    private QWIPanel QWIPanel;
    private QWIModel qwiModel;
    private PhetApplication schrodingerApplication;
    private QWIOptionsMenu optionsMenu;
    private ParticleUnits particleUnits;
    private ArrayList listeners = new ArrayList();
    private ResolutionControl.ResolutionSetup resolution;
    private static final Random random = new Random(0L);
    boolean firstDetector = true;

    public QWIModule(String string, PhetApplication phetApplication, IClock iClock) {
        super(string, iClock);
        this.schrodingerApplication = phetApplication;
        this.resolution = QWIModule.getResolutionSetups()[0];
        this.setModel(new BaseModel());
        this.setLogoPanelVisible(false);
        this.addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                QWIModule.this.stepInTime(d);
            }
        });
    }

    protected void stepInTime(double d) {
        if (this.qwiModel != null) {
            this.qwiModel.stepInTime(d);
        }
    }

    protected void finishInit() {
        this.getSchrodingerPanel().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 73) {
                    System.out.println("SingleParticleModule.keyPressed, I");
                    QWIModule.this.resetViewTransform();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.optionsMenu = this.createOptionsMenu();
        this.getQWIModel().getDoubleSlitPotential().addListener(new HorizontalDoubleSlit.Listener(){

            public void slitChanged() {
                QWIModule.this.getSchrodingerPanel().updateWaveGraphic();
            }
        });
    }

    protected QWIOptionsMenu createOptionsMenu() {
        return new QWIOptionsMenu(this);
    }

    public void activate() {
        super.activate();
        this.schrodingerApplication.getPhetFrame().addMenu(this.optionsMenu);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.activated();
        }
    }

    public void deactivate() {
        super.deactivate();
        this.schrodingerApplication.getPhetFrame().removeMenu(this.optionsMenu);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.deactivated();
        }
    }

    protected void setQWIModel(QWIModel qWIModel) {
        this.qwiModel = qWIModel;
        this.qwiModel.getDetectorSet().addListener(new DetectorSet.Listener(){

            public void detectionAttempted() {
                QWIModule.this.getSchrodingerPanel().updateWaveGraphic();
            }
        });
    }

    public QWIPanel getSchrodingerPanel() {
        return this.QWIPanel;
    }

    public QWIModel getQWIModel() {
        return this.qwiModel;
    }

    public void reset() {
        this.clearPotential();
        this.qwiModel.reset();
        this.QWIPanel.reset();
        this.resetViewTransform();
    }

    protected void resetViewTransform() {
        this.getSchrodingerPanel().getCamera().setViewTransform(new AffineTransform());
    }

    public void fireParticle(WaveSetup waveSetup) {
        this.qwiModel.fireParticle(waveSetup);
    }

    public void setGridSize(final int n, final int n2) {
        this.getModel().addModelElement(new ModelElement(){

            public void stepInTime(double d) {
                QWIModule.this.qwiModel.setGridSize(n, n2);
                QWIModule.this.getModel().removeModelElement(this);
            }
        });
    }

    public void addDetector() {
        int n;
        int n2 = n = (int)((double)this.getQWIModel().getGridWidth() / 4.5);
        int n3 = random.nextInt(this.getQWIModel().getWavefunction().getWidth() - n);
        int n4 = random.nextInt(this.getQWIModel().getWavefunction().getHeight() - n2);
        if (this.firstDetector) {
            n3 = this.getQWIModel().getWavefunction().getWidth() / 2 - n / 2;
            n4 = this.getQWIModel().getWavefunction().getHeight() / 2;
            this.firstDetector = false;
        }
        Detector detector = new Detector(this.getQWIModel(), n3, n4, n, n2);
        this.addDetector(detector);
    }

    public void addDetector(Detector detector) {
        this.qwiModel.addDetector(detector);
        this.QWIPanel.addDetectorGraphic(detector);
    }

    public void addPotential() {
        int n = (int)((double)this.getQWIModel().getGridWidth() / 4.5);
        int n2 = random.nextInt(this.getQWIModel().getWavefunction().getWidth() - n);
        int n3 = random.nextInt(this.getQWIModel().getWavefunction().getHeight() - n);
        RectangularPotential rectangularPotential = new RectangularPotential(this.getQWIModel(), n2, n3, n, n);
        rectangularPotential.setPotential(1.7976931348623156E306);
        this.qwiModel.addPotential(rectangularPotential);
        RectangularPotentialGraphic rectangularPotentialGraphic = this.createPotentialGraphic(rectangularPotential);
        this.getSchrodingerPanel().addRectangularPotentialGraphic(rectangularPotentialGraphic);
    }

    protected RectangularPotentialGraphic createPotentialGraphic(RectangularPotential rectangularPotential) {
        return new RectangularPotentialGraphic(this.getSchrodingerPanel(), rectangularPotential);
    }

    public IntensityManager getIntensityDisplay() {
        return this.getSchrodingerPanel().getIntensityDisplay();
    }

    protected void setSchrodingerPanel(QWIPanel qWIPanel) {
        this.setSimulationPanel(qWIPanel);
        this.QWIPanel = qWIPanel;
        this.QWIPanel.setUnits(this.particleUnits);
    }

    protected void setSchrodingerControlPanel(QWIControlPanel qWIControlPanel) {
        this.setControlPanel(qWIControlPanel);
    }

    public PhetFrame getPhetFrame() {
        return this.schrodingerApplication.getPhetFrame();
    }

    public void removePotential(RectangularPotentialGraphic rectangularPotentialGraphic) {
        this.getQWIModel().removePotential(rectangularPotentialGraphic.getPotential());
        this.getSchrodingerPanel().removePotentialGraphic(rectangularPotentialGraphic);
    }

    public void clearPotential() {
        this.getQWIModel().clearPotentialIgnoreSlits();
        this.getSchrodingerPanel().clearPotential();
    }

    public void setWaveSize(final int n) {
        Command command = new Command(){

            public void doIt() {
                QWIModule.this.getQWIModel().setWaveSize(n, n);
                QWIModule.this.getSchrodingerPanel().setWaveSize(n, n);
            }
        };
        if (!this.getClock().isPaused()) {
            this.getModel().execute(command);
        } else {
            command.doIt();
        }
    }

    public Map getModelParameters() {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.getQWIModel().getModelParameters());
        AbstractGunNode abstractGunNode = this.getSchrodingerPanel().getGunGraphic();
        Map map = abstractGunNode.getModelParameters();
        hashtable.putAll(map);
        return hashtable;
    }

    public void removeAllDetectors() {
        while (this.qwiModel.getDetectorSet().numDetectors() > 0) {
            this.getSchrodingerPanel().removeDetectorGraphic(this.qwiModel.getDetectorSet().detectorAt(0));
        }
    }

    public void removeAllPotentialBarriers() {
        while (this.qwiModel.getCompositePotential().numPotentials() > 0) {
            this.getQWIModel().removePotential(this.qwiModel.getCompositePotential().potentialAt(0));
        }
    }

    public void setUnits(ParticleUnits particleUnits) {
        this.particleUnits = particleUnits;
        if (this.QWIPanel != null) {
            this.QWIPanel.setUnits(particleUnits);
        }
    }

    public boolean confirmReset() {
        return true;
    }

    public void setCellSize(int n) {
        this.QWIPanel.setCellSize(n);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void beamTypeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.beamTypeChanged();
        }
    }

    public static ResolutionControl.ResolutionSetup[] getResolutionSetups() {
        int[] nArray = new int[]{8, 4, 2};
        String[] stringArray = new String[]{"low", "medium", "high"};
        double[] dArray = new double[]{1.0, 0.5, 0.25};
        double[] dArray2 = new double[]{1.0, 0.25, 0.0625};
        ResolutionControl.ResolutionSetup[] resolutionSetupArray = new ResolutionControl.ResolutionSetup[nArray.length];
        for (int i = 0; i < resolutionSetupArray.length; ++i) {
            resolutionSetupArray[i] = new ResolutionControl.ResolutionSetup(nArray[i], stringArray[i], dArray[i], dArray2[i]);
        }
        return resolutionSetupArray;
    }

    public ResolutionControl.ResolutionSetup getResolution() {
        return this.resolution;
    }

    public void setResolution(ResolutionControl.ResolutionSetup resolutionSetup) {
        this.resolution = resolutionSetup;
    }

    public void setMinimumProbabilityForDetection(double d) {
        this.getSchrodingerPanel().getIntensityDisplay().setMinimumProbabilityForDetection(d);
    }

    public void setTimeThresholdCount(int n) {
        this.getSchrodingerPanel().getIntensityDisplay().setTimeThreshold(n);
    }

    public void setTimeThreshold(boolean bl) {
        this.getSchrodingerPanel().getIntensityDisplay().setTimeThreshold(bl);
    }

    public void debugSymmetry() {
        this.qwiModel.debugSymmetry();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public boolean hasHelp() {
        return false;
    }

    public static interface Listener {
        public void deactivated();

        public void activated();

        public void beamTypeChanged();
    }
}

