/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.util;

import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JFrame;

public interface FrameSetup {
    public void initialize(JFrame var1);

    public static class CenteredWithSize
    implements FrameSetup {
        private int frameWidth;
        private int frameHeight;

        public CenteredWithSize(int n, int n2) {
            this.frameWidth = Math.min(this.getAvailableWidth(), n);
            this.frameHeight = Math.min(this.getAvailableHeight(), n2);
        }

        private int getAvailableWidth() {
            return Toolkit.getDefaultToolkit().getScreenSize().width - this.getInsets().left - this.getInsets().right;
        }

        private int getAvailableHeight() {
            return Toolkit.getDefaultToolkit().getScreenSize().height - this.getInsets().top - this.getInsets().bottom;
        }

        private Insets getInsets() {
            return Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        }

        private Rectangle getAvailableRectangle() {
            return new Rectangle(this.getInsets().left, this.getInsets().top, this.getAvailableWidth(), this.getAvailableHeight());
        }

        public void initialize(JFrame jFrame) {
            jFrame.setLocation((int)this.getAvailableRectangle().getCenterX() - this.frameWidth / 2, (int)this.getAvailableRectangle().getCenterY() - this.frameHeight / 2);
            jFrame.setSize(this.frameWidth, this.frameHeight);
        }
    }
}

