/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view;

import edu.colorado.phet.common.phetcommon.math.ModelViewTransform1D;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ModelSlider
extends JPanel {
    private JTextField textField;
    private JSlider slider;
    private ModelViewTransform1D modelViewTransform;
    private String units;
    private Font titleFont = new PhetFont(1, 12);
    private NumberFormat textFieldFormat;
    private NumberFormat sliderLabelFormat;
    private double min;
    private double max;
    private double initialValue;
    private ArrayList listeners = new ArrayList();
    private double value = Double.NaN;
    private int numMajorTicks;
    private int numMinorTicks;
    private JLabel titleLabel;
    private JTextField unitsReadout;
    private String title;
    private JPanel textPanel;
    private boolean settingSliderValue = false;

    public ModelSlider(String string, String string2, double d, double d2, double d3) {
        this(string, string2, d, d2, d3, new DecimalFormat("0.0#"), new DecimalFormat("0.0#"));
    }

    public ModelSlider(String string, String string2, double d, double d2, double d3, NumberFormat numberFormat) {
        this(string, string2, d, d2, d3, numberFormat, numberFormat);
    }

    public ModelSlider(String string, String string2, double d, double d2, double d3, NumberFormat numberFormat, NumberFormat numberFormat2) {
        this.init(d, d2, numberFormat, numberFormat2, string2, d3, string);
    }

    private void init(double d, double d2, NumberFormat numberFormat, NumberFormat numberFormat2, String string, double d3, String string2) {
        while (this.getComponentCount() > 0) {
            this.remove(this.getComponent(0));
        }
        this.title = string2;
        this.min = d;
        this.max = d2;
        this.textFieldFormat = numberFormat;
        this.sliderLabelFormat = numberFormat2;
        this.units = string;
        this.modelViewTransform = new ModelViewTransform1D(d, d2, 0, 100000000);
        this.initialValue = d3;
        this.numMajorTicks = 5;
        int n = 2;
        this.numMinorTicks = (this.numMajorTicks - 1) * n + 1;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.createTextField();
        this.textField.setHorizontalAlignment(4);
        this.createSlider();
        this.titleLabel = new JLabel(string2){

            protected void paintComponent(Graphics graphics) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(graphics);
            }
        };
        this.titleLabel.setFont(this.titleFont);
        this.unitsReadout = new JTextField(" " + this.units);
        this.unitsReadout.setFocusable(false);
        this.unitsReadout.setEditable(false);
        this.unitsReadout.setBorder(null);
        this.textPanel = new JPanel();
        this.textPanel.setLayout(new BorderLayout());
        this.textPanel.add((Component)this.textField, "West");
        this.textPanel.add((Component)this.unitsReadout, "East");
        try {
            SwingUtils.addGridBagComponent(this, this.titleLabel, 0, 0, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, this.slider, 0, 1, 1, 1, 0, 10);
            SwingUtils.addGridBagComponent(this, this.textPanel, 0, 2, 2, 1, 0, 10);
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        this.setValue(d3);
    }

    private void createSlider() {
        int n = this.modelViewTransform.modelToView(this.initialValue);
        if (n < 0 || n > 100000000) {
            throw new RuntimeException("Illegal slider value, min=0, max=100000000, value=" + n);
        }
        final JSlider jSlider = new JSlider(0, 0, 100000000, n);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue();
                double d = ModelSlider.this.modelViewTransform.viewToModel(n);
                if (!ModelSlider.this.settingSliderValue) {
                    ModelSlider.this.setValue(d);
                }
            }
        });
        int n2 = 100000000 / (this.numMinorTicks - 1);
        double d = Math.abs(this.modelViewTransform.viewToModel(n2 / 4));
        SliderKeyHandler sliderKeyHandler = new SliderKeyHandler(d);
        jSlider.addKeyListener(sliderKeyHandler);
        this.slider = jSlider;
        this.relabelSlider();
    }

    private void createTextField() {
        JTextField jTextField = new JTextField(8);
        jTextField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                ModelSlider.this.setValue(ModelSlider.this.getValue());
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    ModelSlider.this.testCommit();
                } else if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 27) {
                    ModelSlider.this.setValue(ModelSlider.this.initialValue);
                }
            }
        });
        this.textField = jTextField;
    }

    private void relabelSlider() {
        int n = 100000000 / (this.numMajorTicks - 1);
        int n2 = 100000000 / (this.numMinorTicks - 1);
        PhetFont phetFont = new PhetFont(0, 10);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        for (int i = 0; i <= 100000000; i += n) {
            double d = this.modelViewTransform.viewToModel(i);
            JLabel jLabel = new JLabel(this.sliderLabelFormat.format(d));
            jLabel.setFont(phetFont);
            hashtable.put(new Integer(i), jLabel);
        }
        this.slider.setLabelTable(hashtable);
        this.slider.setMajorTickSpacing(n);
        this.slider.setMinorTickSpacing(n2);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.slider.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.unitsReadout.setEnabled(bl);
        this.titleLabel.setEnabled(bl);
        Enumeration enumeration = this.slider.getLabelTable().keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this.slider.getLabelTable().get(k);
            if (!(v instanceof Component)) continue;
            Component component = (Component)v;
            component.setEnabled(bl);
        }
    }

    public void setModelTicks(double[] dArray) {
        Hashtable<Double, JLabel> hashtable = new Hashtable<Double, JLabel>();
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            hashtable.put(new Double(d), new JLabel(this.sliderLabelFormat.format(d)));
        }
        this.setModelLabels(hashtable);
    }

    public void setModelLabels(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Set set = hashtable.keySet();
        for (Object k : set) {
            Number number = (Number)k;
            double d = number.doubleValue();
            int n = this.modelViewTransform.modelToView(d);
            hashtable2.put(new Integer(n), hashtable.get(k));
        }
        this.slider.setLabelTable(hashtable2);
    }

    private void fireStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener changeListener = (ChangeListener)this.listeners.get(i);
            ChangeEvent changeEvent = new ChangeEvent(this);
            changeListener.stateChanged(changeEvent);
        }
    }

    public boolean testCommit() {
        try {
            this.commitEdit();
            return true;
        }
        catch (IllegalValueException illegalValueException) {
            String string = PhetCommonResources.getInstance().getLocalizedString("Common.ModelSlider.OutOfRange");
            String string2 = PhetCommonResources.getInstance().getLocalizedString("Common.ModelSlider.Minimum");
            String string3 = PhetCommonResources.getInstance().getLocalizedString("Common.ModelSlider.Maximum");
            String string4 = PhetCommonResources.getInstance().getLocalizedString("Common.ModelSlider.YouEntered");
            String string5 = PhetCommonResources.getInstance().getLocalizedString("Common.ModelSlider.Description");
            PhetOptionPane.showMessageDialog(this, string + ".\n" + string2 + "= " + illegalValueException.getMin() + ", " + string3 + "=" + illegalValueException.getMax() + "\n" + string4 + ": " + illegalValueException.getValue(), string5, 0);
            double d = this.getValue();
            this.textField.setText(this.textFieldFormat.format(d));
            return false;
        }
    }

    public void setTextFieldVisible(boolean bl) {
        this.textPanel.setVisible(bl);
    }

    public void commitEdit() throws IllegalValueException {
        String string = this.textField.getText();
        try {
            double d = DecimalFormat.getNumberInstance().parse(string).doubleValue();
            if (!(d >= this.min) || !(d <= this.max)) {
                throw new IllegalValueException(this.min, this.max, d);
            }
            this.setValue(d);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    public void setValue(double d) {
        if (this.slider.getValue() == this.modelViewTransform.modelToView(d) && this.value == d) {
            return;
        }
        if (d >= this.min && d <= this.max) {
            String string = this.textFieldFormat.format(d);
            double d2 = d;
            try {
                d2 = this.textFieldFormat.parse(string).doubleValue();
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            if (this.slider.getValue() == this.modelViewTransform.modelToView(d) && this.value == d2) {
                return;
            }
            this.value = d2;
            this.textField.setText(string);
            int n = this.modelViewTransform.modelToView(d);
            if (n != this.slider.getValue()) {
                this.settingSliderValue = true;
                this.slider.setValue(n);
                this.settingSliderValue = false;
                this.slider.revalidate();
                this.slider.repaint();
            }
            this.fireStateChanged();
        }
    }

    public double getValue() {
        return this.value;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public static class IllegalValueException
    extends Exception {
        private double min;
        private double max;
        private double value;

        public IllegalValueException(double d, double d2, double d3) {
            super(IllegalValueException.class.getName() + " min=" + d + ", max=" + d2 + " value=" + d3);
            this.min = d;
            this.max = d2;
            this.value = d3;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getValue() {
            return this.value;
        }
    }

    private class SliderKeyHandler
    implements KeyListener {
        int keyCode = -1;
        private Timer timer;
        private double delta;

        public SliderKeyHandler(double d) {
            this.delta = d;
            this.timer = new Timer(30, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SliderKeyHandler.this.fire();
                }
            });
            this.timer.setInitialDelay(300);
        }

        private void fire() {
            if (this.keyCode == -1) {
                return;
            }
            if (this.keyCode == 37 || this.keyCode == 40) {
                double d = ModelSlider.this.getValue() - this.delta;
                if (d < ModelSlider.this.min) {
                    d = ModelSlider.this.min;
                }
                ModelSlider.this.setValue(d);
            } else if (this.keyCode == 39 || this.keyCode == 38) {
                double d = ModelSlider.this.getValue() + this.delta;
                if (d > ModelSlider.this.max) {
                    d = ModelSlider.this.max;
                }
                ModelSlider.this.setValue(d);
            } else if (this.keyCode == 27 || this.keyCode == 32) {
                ModelSlider.this.setValue(ModelSlider.this.initialValue);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.keyCode = keyEvent.getKeyCode();
            this.fire();
            this.timer.setInitialDelay(200);
            this.timer.start();
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.keyCode = -1;
            this.timer.stop();
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.keyCode = keyEvent.getKeyCode();
            this.fire();
        }
    }
}

