/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.flashlauncher.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class SimulationProperties {
    private String project;
    private String simulation;
    private String language;
    private String country;
    private String type;

    public SimulationProperties() throws IOException {
        this(Thread.currentThread().getContextClassLoader().getResourceAsStream("simulation.properties"));
    }

    public SimulationProperties(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.setProperties(properties);
    }

    private void setProperties(Properties properties) {
        this.setProperties(properties.getProperty("project"), properties.getProperty("simulation"), properties.getProperty("language"), properties.getProperty("country"), properties.getProperty("type"));
    }

    private void setProperties(String string, String string2, String string3, String string4, String string5) {
        this.project = string;
        this.simulation = string2;
        this.language = string3;
        this.country = string4;
        this.type = string5;
    }

    public boolean isDevelopment() {
        return false;
    }

    public String getSimulation() {
        return this.simulation;
    }

    public String getProject() {
        return this.project;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("project=" + this.project);
        stringBuffer.append(",simulation=" + this.simulation);
        stringBuffer.append(",language=" + this.language);
        stringBuffer.append(",country=" + this.country);
        stringBuffer.append(",type=" + this.type);
        return stringBuffer.toString();
    }
}

