#!/bin/bash
# Script to use Weria Pezeshkian's pov2xtc script to convert a sequence of povray snapshots into the VMD format files:
#
#   *.gro
#   *.xtc
#
# It must be executed in the directory containing the povray files, but finds the pov2xtc script through the path specified
# by the scriptDir variable. Note that the minimum period between snapshots is 1000 timesteps.
#
#  Usage
#  *******
#
#  pov2vmd  p001  1  10  10
#
#  This would expect there to be 10 snapshot files in the current directory named:
#
#  dmpccs.p001.con.10000.pov
#  dmpccs.p001.con.20000.pov
#  dmpccs.p001.con.30000.pov
#  ...
#
#  dmpccs.p001.con.100000.pov
#
#  Arguments
#  *********
#
#  $1 = Alphanumeric "runId" for the run: dmpci.runId
#  $2 = Integer counter for the first snapshot in units of $4
#  $3 = Integer counter for the last snapshot in units of $4
#  $4 = Interval in timesteps between snapshots in units of 1000 timesteps
#

if [ $# -ne 4  ]; then echo "****** Insufficent arguments to script (supply prefix (e.g., rod), first time, last time and period all in units of 1000: aborting ******"; exit ; fi

# Replace the following path by the one pointing to where you have stored the pov2xtc executable.

scriptDir=~/BIO-692-Exercises/VMD/povtoxtc

echo "Using args " $*

$scriptDir/pov2xtc  -id $1  -b $2  -e $3  -j $4

mv output.gro  $1.gro
mv output.xtc  $1.xtc



