#!/bin/bash
# Script to get the number of snapshot files associated with a given runId and then invoke the
# pov2vmd script on them to create *.gro *.xtc files for making a movie in vmd. Note that the number
# of time steps between snapshots is required.
#
# $1 = runId
# $2 = interval between snapshots/1000

# Execute the shell command to count the number of povray files. Note how we need double quotes around the
# variable when we use it in the subsequent command.

if [ $# != 2 ]; then echo "****** Insufficent arguments to script: enter runId and snapshot interval/1000, aborting ******"; exit ; fi

nt=$(ls dmpccs.$1.*.pov|wc -l)

echo "${nt}"

~/BIO-501-Figures/Scripts/pov2vmd.sh $1 1 "${nt}"  $2

