#!/bin/bash
#
# Script to take povray files for a given run that have an increment of 100 and multiply by 10 to make 
# it 1000 so that they can be processed. Note that we have to rename the files starting
# with the highest to avoid them being overwritten when the lower ones are increased.

#
#
# Version History
# ***************
#
#  04/02/20  1.0  Author: Julian Shillcock. Hardwired to work for 5 digits or less.
#
#
#
# Arguments
# *********
# 1 = suffix  - runId for the run whose povray files are to be modified
#

if [ $# -ne 1 ]; then echo "****** Insufficent arguments to script (supply runId only, e.g., rod603r12), aborting ******"; exit ; fi

runid=$1

# First, rename the 100000s, 10000s, then the 1000s, then 100s.

for file in dmpccs.$runid.con.??????.pov; do mv $file  ${file%.pov}0.pov; done

for file in dmpccs.$runid.con.?????.pov; do mv $file  ${file%.pov}0.pov; done

for file in dmpccs.$runid.con.????.pov; do mv $file  ${file%.pov}0.pov; done

for file in dmpccs.$runid.con.???.pov; do mv $file  ${file%.pov}0.pov; done
