# BIO 512 - Digital Epidemiology Project Prototyping Workshop 1 🧬📊

Welcome to the **Streamlit Workshop**! 🚀

In this workshop, we will learn how to build beautiful, interactive web applications using only Python with [Streamlit](https://streamlit.io/). This repository walks you through a step-by-step tutorial on building a functional project prototype with Streamlit — from setting up a multi-page layout to visualizing data and integrating an LLM-powered chatbot!

## 📚 Learning Git

If you're not familiar with Git, fear not! It's a powerful tool for version control and collaboration on coding projects. We highly recommend starting with this friendly guide to learn the basics: [Git Guide for Beginners](https://rogerdudler.github.io/git-guide/)

## 🛠 Setting Up Your Repository

Before diving into your project, please ensure your repository is set up correctly by following these initial steps:

1.  Add your ssh keys (or access tokens) on gitlab.epfl.ch: <https://gitlab.epfl.ch/-/profile/keys>
2.  Clone this repository to your local machine using your preferred Git client or the command line.

## 🎆 Tutorial :

This tutorial is based on a previous project aimed at supporting mothers recently diagnosed with gestational diabetes.The goal of this project is to allow users better understand their health data and support them in improving their glycemic control. The project is a web application that visualizes continuous glucose monitoring (CGM) data in a clear, user-friendly way, with LLM-powered features.

### Tech Stack:

List of all the Python libraries for this project. See `Installation Steps`\` for downloads instructions.

-   pandas
-   numpy
-   datetime
-   streamlit
-   matplotlib
-   openai
-   python-dotenv
-   plotly

### Installation Steps:

To install all the libraries mentioned in the Tech Stack it is best to create a virtual environment. To do so, open a terminal and run the following command:

`conda create -n Streamlit_workshop1`

Then activate the virtual environment and navigate to this repository:

`conda activate Streamlit_workshop`

`cd path/to/Streamlit_workshop`

You can then install all of the necessary packages at once, using the following command:

`pip install -r requirements.txt`

The web app can now be accessed by running the following command:

`streamlit run main.py`

You're all set to start this tutorial !

### Data Sources:

-   The `example_data_1_subject.csv` dataset is part of the `iglu` R package, which is designed for analyzing blood glucose data. The package and its functionalities are detailed in Broll et al. (2021), published in PLOS ONE (doi: <https://doi.org/10.1371/journal.pone.0248560>).

## ❓Support

If you have any questions or need assistance with your project, please don't hesitate to reach out to your instructors or TAs. You can also use the 'Discussions' feature in this Git repository for general queries or to seek help from your peers.