from agents import Agent, WebSearchTool
from agents.model_settings import ModelSettings

INSTRUCTIONS = (
    "You are a research assistant specializing in prices of food items. "
    "Given a search term, use web search to retrieve up‑to‑date context and prices of the food. "
    "If the search is not about food, return 'invalid search term'"
    "Produce a short summary of at most 100 words."
    "Include key nutritional information alongside pricing data when relevant."
)

price_search_agent = Agent(
    name="Food Price Research Agent",
    instructions=INSTRUCTIONS,
    tools=[WebSearchTool()],
    model_settings=ModelSettings(tool_choice="required"),
)
