import asyncio
import pandas as pd
from openai.types.responses import ResponseContentPartDoneEvent, ResponseTextDeltaEvent

from agents import (
    Agent,
    Runner,
    TResponseInputItem,
    RawResponsesStreamEvent,
)
from dotenv import load_dotenv

load_dotenv()

nutrition_df = pd.read_csv("data/example_intake_data.csv")
nutrition_json = nutrition_df.to_json(orient="records")


# --- Main Nutrition Tracking Agent ---

nutrition_agent = Agent(
    name="Nutrition Tracking Assistant",
    instructions=f"""You are a nutrition tracking assistant.
    You are responsible answering questions about the user's nutritional intake.
    Here is the data of the user's nutritional intake: {nutrition_json}
""",
    model="gpt-4o-mini",
)


async def main():

    msg = input(
        "👋 Hi! We have your nutritional intake data. What do you want to know? "
    )
    # if msg.lower() == "quit":
    #     return
    inputs: list[TResponseInputItem] = [{"content": msg, "role": "user"}]

    while True:
        result = Runner.run_streamed(
            nutrition_agent,
            input=inputs,
        )
        async for event in result.stream_events():
            if not isinstance(event, RawResponsesStreamEvent):
                continue
            data = event.data
            if isinstance(data, ResponseTextDeltaEvent):
                print(data.delta, end="", flush=True)
            elif isinstance(data, ResponseContentPartDoneEvent):
                print("\n")

        inputs = result.to_input_list()
        print("\n")
        user_msg = input("💬 Enter a message: ")
        if user_msg.lower() == "quit":
            print("👋 See you space cowboy!")
            break
        inputs.append({"content": user_msg, "role": "user"})
        # nutrition_agent = result.current_agent


if __name__ == "__main__":
    asyncio.run(main())
