function [hf,hax] = RAPTOR_print_snapshot(outs,gui_config,twin,time,size,fname)
% function RAPTOR_print_snapshot(out,gui_config,twin,time,size,fname)
% print snapshot of RAPTOR GUI to .eps file
% outs: cell array of out structures
% gui_config: your favourite RAPTOR_plot_gui configuration
% twin: time window [start end]
% time: time for snapshot
% size: size in pixels [width x height]
% fname: filename (no extension)

[hf,hax] = RAPTOR_plot_GUI(outs,gui_config,twin,time);
set(hf,'units','pixels','position',[100 100 size(1),size(2)]);
set(hf,'paperpositionmode','auto');
%%
print(hf,'-depsc',fname);

fprintf('printed %s.eps\n',sprintf('%s',fname));