function pp = GUI_config_powerbalance
pp = RAPTOR_plot_GUI; % get defaults

p={}; % init
% Ip
ax = 1;
p = [p,{struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ip(end,:)' ,'ylabel','I_p[MA]','yscale',1e-6,'axesnr',ax,'linestyle','-')}];

% temperature 
ax = 5;
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.te(1,:)' ,'ylabel','T_{e0}[keV]','yscale',1e-3,'axesnr',ax,'linestyle','-')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ti(1,:)' ,'ylabel','T_{i0}[keV]','yscale',1e-3,'axesnr',ax,'linestyle','--')];

% density
ax = 9;
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ne(1,:)' ,'ylabel','n_{e0}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle','-.')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ni(1,:)' ,'ylabel','n_{i0}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle',':')];

% input powers
ax = 13;
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbe(end,:)' ,'ylabel','\SigmaP_{nbe}[MW]','yscale',1e-6,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbi(end,:)' ,'ylabel','\SigmaP_{nbi}[MW]','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pice(end,:)' ,'ylabel','\SigmaP_{ice}[MW]','yscale',1e-6,'axesnr',ax,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pici(end,:)' ,'ylabel','\SigmaP_{ici}[MW]','yscale',1e-6,'axesnr',ax,'linestyle',':')];
  
ax = 14;
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pec(end,:)' ,'ylabel','\SigmaP_{ec}','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Poh(end,:)' ,'ylabel','\SigmaP_{oh}','yscale',1e-6,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Palphatot(end,:)' ,'ylabel','\SigmaP_{\alpha}[MA]','yscale',1e-6,'axesnr',ax,'linestyle',':')];

ax = 2;
% kinetic profiles
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.te(:,%i)' ,'ylabel','T_e[keV]','yscale',1e-3,'axesnr',ax,'linestyle','-')];

ax = 3;
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ti(:,%i)' ,'ylabel','T_i[keV]','yscale',1e-3,'axesnr',ax,'linestyle','--')];


% density
ax = 4;
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ne(:,%i)' ,'ylabel','n_{e}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ni(:,%i)' ,'ylabel','n_{i}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle',':')];

ax = 6;

% power density components
callstr = 'out.poh(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata', callstr ,'ylabel','p_{\Omega}','yscale',1e-6,'axesnr',ax,'linestyle','-')];

callstr = 'out.palphae(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata', callstr ,'ylabel','p_{\alpha}','yscale',1e-6,'axesnr',ax,'linestyle',':')];

callstr = 'out.pnbe(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbe}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','o')];

callstr = 'out.pice(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ice}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','x')];

callstr = 'out.pec(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ec}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','--')];

% power to ions
ax = 7;
callstr = 'out.pnbi(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbi}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-','marker','.')];

callstr = 'out.pici(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ici}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','--','marker','o')];

callstr = 'out.pei(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ei}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','s')];


% sinks for electrons
ax = 10;
callstr = 'out.pei(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ei}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','s')];

callstr = 'out.prad(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{prad}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','x')];

callstr = 'out.pbrem(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{pbrem}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','o')];

% sinks for ions
% none yet...

% cumulative power to electrons
ax = 15;
callstr = 'out.Penet_profile(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','\int p_{e,net}[MW/m^2]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','s')];

callstr = 'out.We_transport_flux(:,%i)';
p = [p, struct('xdata','out.rhogauss','xlabel','\rho',...
    'ydata',callstr,'ylabel','\int w_{e,flux}[MW/m^2]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','.')];

ax = 16;
callstr = 'out.Pinet_profile(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','\int p_{i,net}[MW/m^2]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','s')];

callstr = 'out.Wi_transport_flux(:,%i)';
p = [p, struct('xdata','out.rhogauss','xlabel','\rho',...
    'ydata',callstr,'ylabel','\int w_{i,flux}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','.')];



% automatically spaced positions for axes
pp.plots = p; % reassign
pp.axes =  axespos(4,4,[0.05 0.05],[0.05 0.05],[0.05 0.05]);

end