function varargout = prad(varargin) %#codegen
% Radiated power
%
% returns radiated power and derivatives. all outputs are on grid [rhogauss]
%
% Several options are available, set by 'cp.modeltype' options:
%   *'linerad': analytical formula for line radiation power loss
%   *'manual': profiles on rhogauss, fixed or time-varying.
%   *'adas': fits from ADAS cooling factors

%% DEFAULT PARAMETERS

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input processing

if nargin == 0
  varargout{1} = RAPTORmodule('prad_line'); % load default params
  return
elseif nargin == 2
  error('this use is deprecated, use RAPTORmodule(..) instead')
  module_config = varargin{1};
  % get default parameters for each case
  switch module_config.modeltype
    case 'linerad'
      [~,~,def_params] = prad_line;
    case 'manual'
      [~,~,def_params] = prad_manual;
   case 'adas'
      [~,~,def_params] = prad_adas;
    otherwise
      error('invalid Prad model type ''%s''',module_config.modeltype)
  end
  
  mm.name = mfilename;
  mm.modeltype = module_config.modeltype;
  
  varargout{1} = mm;
  varargout{2} = def_params; % return appropriate parameter structure
  return
elseif nargin==5 % change this depending on number of inputs to module
  stap  = varargin{1};
  %geop  = varargin{2};
  it    = varargin{3};
  model = varargin{4};
  pr    = varargin{5}; % params.prad
else
  error('must call with 0 or 5 inputs');
end

%%%% PRAD MODULE

switch model.prad.modeltype
  case 'linerad'
    if nargout<3
      [Prad] = prad_line(stap,it,model,pr);
    elseif nargout==4
      [Prad,dPrad_dx] = prad_line(stap,it,model,pr);
    else
       error('wrong amount of input arguments')
    end
  case 'manual' % 2 possibilities: time-independent profile or time-dependent profille
    if nargout<3
      Prad = prad_manual(stap,it,model,pr);
    elseif nargout == 4
      [Prad,dPrad_dx] = prad_manual(stap,it,model,pr);
    else
      error('wrong number of input arguments')
    end
  case 'adas'
    if nargout<3
      Prad = prad_adas(stap,it,model,pr);
    elseif nargout == 4
      [Prad,dPrad_dx] = prad_adas(stap,it,model,pr);
    else
      error('wrong number of input arguments')
    end
  otherwise
    error('invalid setting for Prad model');
end

% outputs
varargout{1} = Prad;
varargout{2} = zeros(size(Prad));
if nargout>2
  varargout{3} = dPrad_dx;
  varargout{4} = zeros(size(dPrad_dx));
end

end
