function success = qlknn_compile(varargin)
if nargin >= 1
  clean = varargin{1};
else
  clean = false;
end
if nargin >= 2
  use_mpi = varargin{2};
else
  use_mpi = false;
end
if nargin >= 3
  use_mkl = varargin{3};
  error('Building with MKL not implemented yet')
else
  use_mkl = false;
end
% Set up paths to all needed scripts/files
RAPTORpath = RAPTOR_path();
qlknnPath = fullfile(RAPTORpath,'submodules','QLKNN-fortran');
qlknnPath_bin = fullfile(qlknnPath, 'bin');

% Compiler/machine specific options
mkl_root_path = '/opt/intel/mkl';
if use_mpi
  tubscfg_mpi = '1';
else
  tubscfg_mpi = '0';
end
if use_mkl
  tubscfg_mkl = '1';
else
  tubscfg_mkl = '0';
end

% Find mex command
mex_cmd = fullfile(matlabroot, 'bin','mex');

old_pwd = pwd;
chdir(qlknnPath)
% Run QLKNN-fortran Makefile
try
  if clean
    [status(1),~] = system('make distclean', '-echo');
  end
  cmd = ['make TOOLCHAIN=gcc BUILD=release TUBSCFG_MPI=' tubscfg_mpi ' TUBSCFG_MKL=' tubscfg_mkl ' MEX=' mex_cmd ' ' qlknnPath_bin '/qlknn_mex.mexa64'];
  [status(2),~] = system(cmd, '-echo');
catch ME
  rethrow(ME)
end
chdir(old_pwd)

if (all(status == 0))
  success = true;
else
  success = false;
end
end
