function [Te,Dens,Q,HeaderComment,year_out,source] = read_adf11(element,table,year,source)

Te = [];
Dens = [];
Q = [];
HeaderComment = '';
year_out = NaN;

ADAS_URL='open.adas.ac.uk';
ADAS_PREF_ORDER=[12,96,93,92,89,85,74,50];

if nargin < 4 || isempty(year)
   year = ADAS_PREF_ORDER;
end

lecok = 0;
for k =1: length(year)
  try
  [data,etat] = urlread(sprintf('https://%s/download/%s/%s%d/%s%d_%s.dat',ADAS_URL,'adf11',table,year(k),table,year(k),lower(element)));

  if etat ~= 0
     fname = sprintf('%s.dat',tempname);
     fid   = fopen(fname,'w');
     fprintf(fid,'%s\n',data);
     fclose(fid);
     [Te,Dens,Q,HeaderComment]=rd_ADF11(fname);
     delete(fname);

     if ~isempty(HeaderComment)
        lecok = 1;
        year_out = year(k);
        break;
     end
  end
  end
end

if lecok
  Q  = reshape(Q,[length(Dens),length(Te),size(Q,2)]);
  Te = Te';
end

