function outt = slice2time(out,twin)
% function outt = slice2time(out,twin)
% Convert time slice to time window for plotting.
% out: RAPTOR output with one time slicde
% twin: time window [tstart,tend]
%
% outt: RAPTOR output with two time slices at [tstart,tend]

assert(numel(out.time)==1,'input structure must be a time slice with only 1 time')

skipfields = {'rho','rhogauss'};

fields = fieldnames(out);
for ifields = 1:numel(fields)
 myfield = fields{ifields};
 for ii=1:numel(skipfields);
   if isequal(myfield,skipfields{ii})
     skip = true; break;
   else
     skip = false;
   end
 end
 if skip 
   outt.(myfield) = out.(myfield); 
 else
   outt.(myfield) = repmat(out.(myfield),1,2); % copy to second time slice
 end
end
outt.time = twin;
end
