%% NTM with Modified Rutherford Equation 
function varargout = ntm_mre(varargin)

%% terms g_coeff and h_fact added 02.06.2016 dick hogeweij

if nargin == 0,
    Nntm = uint32(2);
    module_params = struct(...
        'active',true,...    % By default, the model is active
        'debug',false,...     % debug provides internal variables via globals
        'doplot',false,...   % make some plots
        'implicit',false,... % The MRE model is now implemented only explicitly
        'm',[2; 3],...            % List of island poloidal mode numbers
        'n',[1; 2],...            % List of island toroidal mode numbers
        'chiefact_A',[10 10],...  % Increase of chie of 1+chiefact_A at rho_mn
        'chiefact_w',[2 2],...   % Width factor of the chie increase (profile is Gaussian)
        'w_d_e',[0.04 0.04],...    % Marginal island width [m] for diffusion of electrons (default for ITER)
        'w_d_i',[0.04 0.04],...    % Marginal island width [m] for diffusion of ions (default for ITER)
        'a2_bs',[2.6 2.6],...         % Bootstrap growth factor (default for ITER)
        'a_ggj',[1 1],...    % Glasser-Green-Johnson effect, value should be positive
        'resis_fact',[1 1],... % Correction factor for the resistivity
        'w_cd_ntm',[0.03 0.03],...    % Current drive width for NTM stabilization (Full 1/e width) [m]
        'rhodeltap_cl0',-[2; 3],... % Classical growth rate set to -m by default
        'alpha',[0 0],...   % Reduction factor for rsDelta'_0 due to effect of NTM on equilibrium
	'g_coeff',0.6,...   % geometrical coeff in G_cd
	'h_fact',0);	    % factor in front of delta_H (0 = no heating effect on ntm evol.)
    
    def_params = struct(...
                'method','state'    , ... % method for solving NTM
                'n_ntm',Nntm        , ... % number of NTMs
                'eqscal',1          , ... % scaling
                'modeltype' , 'mre' , ... % default module
                'params', module_params); % load default params
    
    
    varargout{1} = def_params;
    return %empty call to get default structures
else
    error('must call with 0 inputs');
end
