function params = set_params_machine(params,machine)

switch machine
  case ITER
    % modules
        
    params.palpha.active = true;
    params.pbrem.active = true;
    params.pei.active = true;
    params.prad.params.active = false;
    
    params.saw.params.active=false;
    
    params.neos.jbsB_fact = 1.15;
    
    params.echcd.params.active = true;
    params.echcd.params.rdep = [0.4 0.55 .2]; % two actuators, set rdep=0 for first, rdep=0.4 for second
    params.echcd.params.wdep = [.05 .05 .05];  % wdep =0.35 for each
    params.echcd.params.cd_eff = [10 11 10];  % current drive efficiency factor: pure ECH for first, co-ECCD for second
    
    params.nbhcd.params.active = true;
    params.nbhcd.params.rdep = [0.26]; %
    params.nbhcd.params.wdep_in= [0.15]; % broad heating
    params.nbhcd.params.wdep_out = [0.75]; % broad heating
    params.nbhcd.params.cd_eff = [4]; % current drive
    
  case JET
    
    params.palpha.active = false;
    params.pbrem.active = true;
    params.pei.active = true;
    params.prad.params.active = false;
    
    params.nbhcd.params.rdep = [0]; % deposition in centre
    params.nbhcd.params.wdep_in= [0.4]; % broad heating
    params.nbhcd.params.wdep_out = [0.25]; % broad heating
    params.nbhcd.params.cd_eff = [0]; % no current drive
    
  case WEST
    
    params.palpha.active = false;
    params.pbrem.active = true;
    params.pei.active = true;
    params.prad.params.active = true;
    
    params.echcd.params.active = true;
    params.echcd.params.rdep = [0.0 0.0 -1 -1];
    params.echcd.params.wdep = [0.3 0.3 0.3 0.3 ];
    params.echcd.params.cd_eff =[0  0   0   0   ];
    
    params.nbhcd.params.active = true;
    params.nbhcd.params.rdep     = [0.05  0.1  0.05  0.05 0.17 0.43 0.37 0.08];
    params.nbhcd.params.wdep_in    = 2*[0.2 0.3  0.3   0.3  0.3  0.18  0.20 0.25]; % 2*half width
    params.nbhcd.params.wdep_out = 2*[0.4 0.35 0.35   0.35  0.35  0.29 0.30 0.35];
    params.nbhcd.params.cd_eff =   [0.5119    0.8123    0.8670    0.5539    0.8647    1.3500    1.5853    0.9539];
    params.nbhcd.params.eta_jec0 = 1/5; % to get about 100kA per 5MW beam power
    params.nbhcd.params.frac_to_electrons  = [1.6926    1.6760    1.6396    1.6527    1.9848    2.4017    2.4039    1.9844]/5; % MW to electrons per MW input power
    
    %         params.lhcd = lhcd('lhcd_gaussian');
    %         params.lhcd.params.active = true;
  case AUG
    params.palpha.active = false;
    params.pbrem.active = true;
    params.pei.active = true;
    params.prad.params.active = false;
    
    params.echcd.params.active = true;
    params.echcd.params.rdep = [0.0 0.0 0.0 0.0 -1 -1 -1 -1]; %use rhodep, not rdep
    params.echcd.params.wdep = [0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3];
    params.echcd.params.cd_eff =[0  0   0   0   0   0   0   0  ];
    
    params.nbhcd.params.active = true;
    params.nbhcd.params.rdep     = [0.05  0.1  0.05  0.05 0.17 0.43 0.37 0.08];
    params.nbhcd.params.wdep_in    = 2*[0.2 0.3  0.3   0.3  0.3  0.18  0.20 0.25]; % 2*half width
    params.nbhcd.params.wdep_out = 2*[0.4 0.35 0.35   0.35  0.35  0.29 0.30 0.35];
    params.nbhcd.params.cd_eff =   [0.5119    0.8123    0.8670    0.5539    0.8647    1.3500    1.5853    0.9539];
    params.nbhcd.params.eta_jcd0 = 1/5; % to get about 100kA per 5MW beam power
    params.nbhcd.params.frac_to_electrons  = [1.6926    1.6760    1.6396    1.6527    1.9848    2.4017    2.4039    1.9844]/5; % MW to electrons per MW input power
  case RFX
    
    params.palpha.active = false;
    params.pbrem.active = true;
    params.pei.active = false;
    params.prad.params.active = true;
  case DEMO
    
    params.palpha.active = true;
    params.pbrem.active = true;
    params.pei.active = true;
    params.prad.params.active = true;
    
    params.saw.params.active=false;
    
    params.echcd.params.active = true;
    params.echcd.params.rdep = [0.4];
    params.echcd.params.wdep = [.1];
    params.echcd.params.cd_eff = [1];
    
    params.nbhcd.params.active = true;
    params.nbhcd.params.rdep = [0.26];
    params.nbhcd.params.wdep_in = [0.15];
    params.nbhcd.params.wdep_out = [0.75];
    params.nbhcd.params.cd_eff = [1];
end