function [Lam,Lamgauss] = get_Lam(eqmodel,prime, varargin)
% get correct Lambda matrix depending on whether prime==1 (d/drho) 
% or prime == 2 (d2/drho2) is required or not
% varargin expects boolean: true for spline basis with imposed pedestal;
% false/empty for default spline basis
if nargin == 2
  use_core_spline_base = false;
else
  use_core_spline_base = varargin{1};
end

if prime==2
  if ~use_core_spline_base
    Lam = eqmodel.Lampp;
    Lamgauss = eqmodel.Lamppgauss;
  else
    Lam = eqmodel.Lampp_hmode;
    Lamgauss = eqmodel.Lamppgauss_hmode;    
  end
elseif prime==1
  if ~use_core_spline_base
    Lam = eqmodel.Lamp;
    Lamgauss = eqmodel.Lampgauss;
  else
    Lam = eqmodel.Lamp_hmode;
    Lamgauss = eqmodel.Lampgauss_hmode;
  end
else
  if ~use_core_spline_base
    Lam = eqmodel.Lam;
    Lamgauss = eqmodel.Lamgauss;
  else
    Lam = eqmodel.Lam_hmode;
    Lamgauss = eqmodel.Lamgauss_hmode;
  end
end

return