function [yp,dyp_dx] = eval_y(x,v,eqmodel,myrgrid,gaussgrid)
% function [yp,dyp_dx] = eval_y(x,v,model,whichgrid)
% Evaluation of quantities that do not depend on g
% #codegen

if ~gaussgrid;
    gauss = false;
    ngrid = myrgrid.nrho;
else
    gauss = true;
    ngrid = myrgrid.nrhogauss;
end

switch eqmodel.method
    case 'state'
    % y is a state that is solved for
        if gauss
            dy_dyhat = eqmodel.Lamgauss;
        else
            dy_dyhat = eqmodel.Lam;
        end
        yp = dy_dyhat*x(eqmodel.xind,:);
        dyp_dx = zeros(ngrid,numel(x));
        dyp_dx(:,eqmodel.xind) = dy_dyhat;
    case 'direct'
        % y is directly specified by v
        if gauss
            yp = eqmodel.Lamgauss*v(eqmodel.vind,:);
        else
            yp = eqmodel.Lam*v(eqmodel.vind,:);
        end
        dyp_dx = zeros(ngrid,numel(x));
    otherwise
        error('eqmodel.method = %s not implemented',eqmodel.method)
end


return
