function [T] = eval_rbphi(x, g, v, model,gauss)
% function [T] = eval_rbphi(x, g, v, model,gauss)
% Evaluates T = RBphi by integrating TT' (eval_ttprime)
%
% Outputs:
% T = RBphi

assert(~gauss,'T=RBphi can be evaluated only for rho grid')

ttprime = eval_ttprime(x,g,v,model,true);
psip = eval_psip(x,g,[],model,true);

% 1/2*T2 = int(TT') dpsi = int (TT' *dpsi/drho) * drho
% integrate using gauss quadrature
%%
cumsumall = cumsum(bsxfun(@times,model.rgrid.wgauss.*psip,ttprime));
hTq = [0;cumsumall(model.rgrid.ngauss:model.rgrid.ngauss:end)];

F = eval_F([],g,[],model,false); % this is F = RBphi from the geometry info
hTq = (hTq-hTq(end)) + F(end).^2/2; % add offset assuming F = T at edge

T = sqrt(2*hTq);
%%

return

