function [prof,dprof_dx] = eval_qnze(profstr,x,g,v,model,gauss,prime)
% evaluate qnze for various cases

if nargout==1
    [p1n,p2n,p1,p2] = qnze(x,g,v,model,gauss,prime);
    if strcmp(p1n,profstr), 
        prof = p1; 
    elseif strcmp(p2n,profstr), 
        prof = p2;
    else
        error('qnze:unknownStr','unknown profstr')
    end
else
    [p1n,p2n,p1,p2,dp1_dx,dp2_dx] = qnze(x,g,v,model,gauss,prime);
    if strcmp(p1n,profstr),
        prof = p1; dprof_dx = dp1_dx;
    elseif strcmp(p2n,profstr)
        prof = p2; dprof_dx = dp2_dx;
    else
        error('qnze:unknownStr','unknown profstr')
    end
end
end