function ne = eval_neLHL(x,g,v,model,true)
% evaluate time evolution of ne profile
% simply calls eval_ne except in case the timewindow contains a LH/HL
% transition with imposed pedestal in H mode (i.e. changing spline basis)
if size(v,2)>1 && strcmp(model.hmode.modeltype,'imposed')
	if any(v(model.hmode.vind.activation, :)) && ~all(v(model.hmode.vind.activation, :))
    hmode_active = v(model.hmode.vind.activation,:) == true;
    ne = zeros(model.rgrid.nrhogauss,numel(hmode_active));
    ne(:,hmode_active) = eval_ne(x(:,hmode_active),g(:,hmode_active),v(:,hmode_active),model,true);
    ne(:,~hmode_active) = eval_ne(x(:,~hmode_active),g(:,~hmode_active),v(:,~hmode_active),model,true);
  else 
    ne = eval_ne(x,g,v,model,true);
  end
else
  ne = eval_ne(x,g,v,model,true);
end
end