function [g2] = eval_g2(~,g,~,model,gauss)
% function [g2] = eval_g2(x,g,v,model,whichgrid)
% g2 = <(nabla V)^2/R^2>
% #codegen

gg2 = eval_gg2([],g,[],model,gauss);
H = eval_H([],g,[],model,gauss);

% g2 = gg2.*r^2 / H^2
if ~gauss
    r = model.rgrid.rho;
else
    r = model.rgrid.rhogauss;
end
g2 = bsxfun(@times,r.^2,gg2)./(H.*H);

diverted = (H(end,:)==0);
g2(end,diverted) = inf;

return