function [Wth,dWth_dx] = eval_Wth(x,g,v,model,gaussgrid)
% function [Wth,dWth_dx] = eval_Wth(x,g,v,model,gaussgrid)
%#codegen

if gaussgrid
    error('Wth is an integral quantity, can not be evaluated on gauss grid')
end

if nargout>1
  [Wthe,dWthe_dx] = eval_Wthe(x,g,v,model,gaussgrid);
  [Wthi,dWthi_dx] = eval_Wthi(x,g,v,model,gaussgrid);
  dWth_dx = dWthe_dx + dWthi_dx;
else
  [Wthe] = eval_Wthe(x,g,v,model,gaussgrid);
  [Wthi] = eval_Wthi(x,g,v,model,gaussgrid);
end
Wth = Wthe+Wthi;


return
