function [ BCval,BCrho,dBCval_du] = eval_BC(v,u,speciesModelBC)
% evaluate boundary condition value for various cases.
% example: eval_BC(x,v,u,model.te.BC);

%#codegen

if strcmp(speciesModelBC,'n/a')
    BCval = [];
    BCrho = [];
    dBCval_du = zeros(0,numel(u));
else
    % get value and derivative
    dBCval_du = zeros(1,numel(u)); % init
    switch speciesModelBC.valueSource
        case 'v'
            BCval = v(speciesModelBC.vind_value);
        case 'u'
            BCval = u(speciesModelBC.uind);
            dBCval_du(speciesModelBC.uind) = 1;
        otherwise
            error('unsupported')
    end
    % get rho
    switch speciesModelBC.rhoSource
        case 'Constant'
            BCrho = speciesModelBC.rho;
        case 'v'
            BCrho = v(speciesModelBC.vind_rho);
        otherwise
            error('unsupported')
    end
end

return