function [rhotor,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin] = ids2geom(equi)
% get geometry information from IMAS equilibrium IDS

% time grid for input data
eq_times = equi.time;
tgridin = [];

if isempty(tgridin)
    
    if numel(eq_times)==1
        fprintf('equilibrium from IDS contains single time slice t=%2.2f\n',eq_times(1));
    else
        fprintf('taking all %d equilibria from IDS from t=%2.2f to t=%2.2f\n',numel(eq_times),eq_times(1),eq_times(end));
    end
    tgridin = eq_times;
else
    error('not defined yet')
end

nbt = numel(tgridin);
%% loop over time and get 1D profiles
for it = 1:numel(tgridin)
    profs = equi.time_slice{it}.profiles_1d;
    
    %% read values
    % NB: these are all in COCOS=11 by default.
    
    rhotor_ca{it} = profs.rho_tor_norm;

    iR2_ca{it} = profs.gm1; 
    iR_ca{it}  = profs.gm9;
    
    dpsidV_ca{it} = 1./profs.dvolume_dpsi; % ok since same eBp in IMAS and RAPTOR
    % fix
    if profs.dvolume_dpsi(1) == 0 
        dpsidV_ca{it} = spline(rhotor_ca{it}(2:end),dpsidV_ca{it}(2:end),rhotor_ca{it});
    end
    dpsi_ca{it} = profs.gm7.*profs.dpsi_drho_tor; % dummy to be used later for ne equations
    dpsi2_ca{it} = profs.gm3.*profs.dpsi_drho_tor.^2;
    dpsi2oR2_ca{it} = profs.gm2.*profs.dpsi_drho_tor.^2;
    
    F_ca{it} = profs.f;
    kappa_ca{it} = profs.elongation;
    delta_ca{it} = (profs.triangularity_lower+profs.triangularity_upper)/2;
    Rgeom_ca{it} = (profs.r_outboard + profs.r_inboard)/2;
    epsilon_ca{it} = (profs.r_outboard-profs.r_inboard)/2 ./Rgeom_ca{it};
    
    Phib(it) = profs.phi(end); % scalar
    
end
   
%% put everything on uniform rhotor grid
if nbt>1
    % unified radial grid for input data
    [rhotor,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta] = ...
        unified_radial_grid(rhotor_ca,iR_ca,iR2_ca,dpsi_ca,dpsi2_ca,dpsi2oR2_ca,dpsidV_ca,F_ca,epsilon_ca,Rgeom_ca,kappa_ca,delta_ca);
else
    rhotor = rhotor_ca{1};
    iR = iR_ca{1};
    iR2 = iR2_ca{1};
    dpsi = dpsi_ca{1};
    dpsi2 = dpsi2_ca{1};
    dpsi2oR2 = dpsi2oR2_ca{1};
    dpsidV = dpsidV_ca{1};
    F = F_ca{1};
    epsilon = epsilon_ca{1};
    Rgeom = Rgeom_ca{1};
    kappa = kappa_ca{1};
    delta = delta_ca{1};
end