function [varargout] = conf_params_LIUQE_call(configequi)
  %[config.equi, params.equi, params.numerics.eq_tran_iter, params.numerics.equi]
  % Special case when liuqe is computed internally during RAPTOR time iteration
  % This allows for iteration between equilibrium and transport
  % The default setting is to run LIUQE standard with no Eq-Tran iteration at every RAPTOR t step
  if ~isfield(configequi, 'code_dir')
      error('missing path specification to meq folder');
  end
  
  if ~exist(configequi.code_dir, 'dir')
      error('configequi.code_dir contains not existing path');
  end
  
  % Check that meq is in pointing to the required
  pold = cd(configequi.code_dir);
  command = 'svn info';
  [status, cmdout] = system(command); % Get svn info of the folder
  tagversionrequest = '4LIURAPintegration'; % name of the tag to be used for the coupling
  linesout = strsplit(cmdout, '\n');
  for ii=1:numel(linesout)
      if strcmp(linesout{ii}(1:4), 'URL:')
          tagversion = regexp( linesout{ii}(6:end), '/', 'split');
          if ~strcmp(tagversion{end}, tagversionrequest)
              error('meq tag at used is not the correct one')
          else
              break
          end
      end
  end
  cd(pold)
  
  
  % Remove other meq folder in path if available
  pathCell = regexp(path, pathsep, 'split');
  for ii=1:numel(pathCell)
      pathii = regexp(pathCell{ii}, '/', 'split');
      if strcmp(pathii{end}, 'meq') && ~strcmp(pathCell{ii}, configequi.code_dir)
          rmpath(pathCell{ii})
      end
  end
  
  % Re-difine the equilibrium structure for this particular case
  configequi = struct( ...
      'tokamak',    configequi.tokamak, ...
      'source' ,    configequi.source, ...
      'eq_call',    configequi.eq_call, ...
      'epsilon',    configequi.epsilon, ...
      'kappa',      configequi.kappa, ...
      'delta',      configequi.delta, ...
      'B0',         configequi.B0, ...
      'R0',         configequi.R0, ...
      'Lext',       configequi.Lext, ...
      'gsplineorder', configequi.gsplineorder, ...% polynomial spline order for geometry interpolation
      'gspline_axis_tens', configequi.gspline_axis_tens, ... % Spline tension for geometrical quantities interpolation at the axis
      'gspline_edge_tens', configequi.gspline_axis_tens, ... % spline tension for geometrical quantities interpolation at the edge
      'gknots', configequi.gknots ... % knots for spline fitting of geometrical parameters
      );
  
  
  %% Default parameters for LIUQE call during RAPTOR predictive time iteration
  params = struct();
  
  params.numerics.equi.N_max_Picard_iter = []; % Set by standard liup
  params.numerics.equi.Picard_iteration_convergence_threshold = []; % Set by standard liup
  
  params.numerics.equi.post_processing_type = 'psitbx'; % 'psitbx', 'RT_like'
  switch params.numerics.equi.post_processing_type
    case 'psitbx'
      params.numerics.equi.N_max_geometrical_iteration = []; % Not used
    case 'RT_like'
      params.numerics.equi.N_max_geometrical_iteration = 10;
    otherwise
      error('params.numerics.equi.post_processing_type not valid')
  end
  params.numerics.equi.outputs_rhopsiNgrid = []; % Set by default liup
 
  %params.eq_tran_iter.N_max_iteration =1. Already set by RAPTOR config. 1 equlibrium and 1 transport at each time iteration.
  params.eq_tran_iter.convergence_threshold = 1e-4; % 1e-4 is faster, 1e-5 more precision
  
  params.equi.L = []; % Input parameter structure for LIUQE
  params.equi.LX = []; % Input data for LIUQE
  
  %% Define outputs
  varargout = {configequi, params.equi, params.eq_tran_iter, params.numerics.equi};