function out=JST2RAPTORout(~,time,data)
% out = JST2RAPTORout(~,time,data,param);
% leave 'time' empty to leave data on original grids

% table of correspondence between RAPTOR out terms and JST data
% structure

map = {
%     {'q'   ,    'data.Q'};
%     {'iota',      '1./data.Q'};
%     {'shear'   ,  'data.SH'};
%     {'q0'   ,    'data.Q(1,:)'};
%     {'qmin'   ,  'min(data.Q, [], 1)'};
     {'B0', 'data.BTOR / 1e4'};
%     {'psi' ,     'data.PSI1 * 1e-8 * 2 * pi'};
%     {'upl' ,     'data.VOLT'};
%     {'te' ,       'data.TE'};
%     {'ti' ,       'data.TI'};
%     {'ne' ,       'data.NE1 * 1e6'};
%     {'ni' ,       'data.NI * 1e6'};
%     {'p'  ,      'data.prof.ptot'},...
%     {'ze' ,       'data.ZEFF'};
%     {'vt' ,       'data.ANGF'};
%     {'Ip' ,       'data.CUR(end, :)'};
%     {'li3' ,     'data.equi.li'},...
%     {'betaN' ,   'data.equi.betan'},...
%     {'beta' ,    '100*data.gene.beta'},...
%     {'jbs',      'data.neo.jboot'},...
%     {'signeo',    'data.SIGM'};
%     {'chie',      'data.XE/1e4'};
%     {'chii',      'data.XI/1e4'};
     {'Pbrem',     'data.PBRE * 1e3'};
     {'Prad' ,     'data.PRAD * 1e3'};
     {'Pei' ,      'data.PTHX * 1e3'};
     {'Poh'  ,     'data.POH * 1e3'};
     {'Pnbe'  ,    'data.PNBE * 1e3'};
     {'Pnbi'  ,    'data.PNBI * 1e3'};
     {'Pece'  ,    'data.PECE * 1e3'};
     {'Pec'  ,     'data.PECE * 1e3'};
     {'Pici',      'data.PRFI * 1e3'};
     {'Pice',      'data.PRFE * 1e3'};
%     {'Paux' ,    'data.gene.paddidn+data.gene.paddfce'},...
%     {'Palphatot', '(data.PALE + data.PALI) * 1e3'};
%     {'Ploss',    'data.gene.ploss'},...
%     {'pbrem',     'data.QBRE * 1e9'};
%     {'prad',      'data.QRAD * 1e9'};
%     {'pei',       'data.QTHX * 1e9'};
%     {'poh',       'data.QOH * 1e9'};
%     {'pnbe',      'data.QNBE * 1e9'};
%     {'pnbi',      'data.QNBI * 1e9'};
%     {'jnb',       'data.JZNB * 3.333333333e-6'};
%     {'pfastnb',   'data.WNBD / 10 * (2/3)'};
%     {'pici',      'data.QRFI * 1e9'};
%     {'pice',      'data.QRFE * 1e9'};
%     {'pece'  ,    'data.QECE * 1e9'};
%     {'pec'  ,     'data.QECE * 1e9'};
%     {'jic',       'data.JZRF * 3.333333333e-6'};
%     {'pfastic',   'data.WRFD / 10 * (2/3)'};
%     {'jec',      'data.source.fce.j'},...
%     {'paux',     'data.source.totale.el'},...
%     {'jni',      'data.source.totale.j'},...
%     {'jaux',     'data.source.totale.j-data.source.jboot'},...
%     {'joh',      'data.prof.jmoy-data.source.totale.j'},...
%     {'jpar',      'data.JP / 3e5'};
%     {'palphae',   'data.QALE * 1e9'};
%     {'palphai',   'data.QALI * 1e9'};
%     {'palphatot','data.source.fus.el+data.source.fus.ion'},...
%     {'jbs',      'data.source.jboot'},...
%     {'sne' ,      'data.SBD1 * 1e6'};
%     {'Ioh',      'data.gene.ipohm'},...
%     {'Ibs',      'data.gene.iboot'},...
%     {'Iaux',     'data.gene.icd'},...
%     {'Ini',      'data.gene.ini'},...
%     {'Iec',      'data.gene.ifce'},...
%     {'Inb',      'data.gene.iidn'},...
%     {'fbs',      'data.gene.iboot./data.gene.ip'},...
%     {'foh',      'data.gene.ipohm./data.gene.ip'},...
%     {'fni',      'data.gene.ini./data.gene.ip'},...
%     {'tauE',     'data.gene.taue'},...
%     {'We'  ,      'sum(data.WE * 1e3)'};
%     {'Wi'  ,      'sum(data.WI * 1e3)'};
%     {'Wth' ,      'sum((data.WE + data.WI)) * 1e3'};
%     {'Wpol',     'data.gene.wbp'},...
%     {'g1'  ,     'data.equi.grho2.*data.equi.vpr.^2'},... <|gradV|^2>
%     {'g2'  ,     'data.equi.grho2r2.*data.equi.vpr.^2'},... <|gradV|^2/R^2>
%     {'g3'  ,     'data.equi.r2i'},... <1/R^2>
%     {'Vp'  ,     'bsxfun(@times,data.equi.rhomax,data.equi.vpr)'},...
%     {'Rgeom',     'data.R(1, :) ./ 100'};
    };

%% grids - use input grids or keep old ones
t_jsp   = data.TVEC1;

if isempty(time)
    interptime = false;
    out.time = t_jsp;
else
    interptime = true;
    out.time = time;
end

out.it = 1:numel(out.time);
out.ntime = numel(out.time);

% first eval all strings to get good data
%data = evalstrings(data);

%% interpolate and map to RAPTOR grid
for im=1:numel(map)
    mym = map{im};
    
    try
        jstdata = full(eval(mym{2}));
        
        % interpolate to new t
        if interptime
            data_on_time = interp1(t_jsp,jstdata',out.time,'linear',NaN)';
        else
            data_on_time = jstdata;
        end

        out.(mym{1}) = data_on_time';
    catch err
        warning('could not interpolate %s to %s',mym{2}, mym{1});
        rethrow(err)
    end
end

function dataout=evalstrings(data)

dataout = data;

fields = fieldnames(data);
for ifield = 1:numel(fields)
    myfieldname = fields{ifield};
    myfield = data.(myfieldname);
    if ischar(myfield)
        dataout.(myfieldname) = eval(myfield);
    elseif isa(myfield,'struct')
        dataout.(myfieldname) = evalstrings(myfield);
    end
end
return
