function [iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhotor,config] = IMASequil2SI(config)
% function [iR,iR2,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin,rhotor] = IMASequil2SI(config)
% Loads IMAS equilibrium data from .mat file containing IMAS equilibirum
% IDS data.
% Returns geometric quantities, corresponding time and radial grids.

% CHEASE file name(s)
file = fullfile(config.envopts.RAPTOR_path,config.equi.filenames{1});
fprintf('loading IMAS equlibrium IDS %s\n',file)
%%
assert(~~exist(file,'file'),'RAPTOR:FileDoesNotExist','File %s does not exist',file)

load(file);
fprintf('   IDS comment: %s\n',equi.ids_properties.comment);

%%
[rhotor,iR,iR2,dpsi,dpsi2,dpsi2oR2,dpsidV,F,epsilon,Rgeom,kappa,delta,Phib,tgridin] = ids2geom(equi);
%%
return
