function out=EQUINOXdata2RAPTORout(rho,time,data)
% out = EQUINOXdata2RAPTORout(rho,time,data);
% data struct containing equinox data
% leave 'rho' or 'time' empty to leave data on original grids


% table of correspondence between RAPTOR out terms and equinox data
% structure

data.Psi = NaN*ones(size(data.q));
data.Psi(:,1) = data.Psia';
data.Psi(:,end) = data.Psib';

map = {{'q' ,       'data.q'},...
       {'iota' ,    '1./data.q'},...
       {'q0' ,      'data.q(:,1)'},...
       {'q95' ,     'data.q95'''},...
       {'qmin' ,    'min(data.q'')'''},...
       {'p' ,       'data.p'},...
       {'Ip' ,      '-data.Ip'''},...
       {'li3' ,     'data.li'''},...
       {'psi' ,     'data.Psi'}
       };

   %% grids - use input grids or keep old ones
   t_equinox   = data.tEq;
   r_equinox = linspace(0,1,11);
   
   if isempty(rho)
       interprho = false;
       out.rho = r_equinox;
   else
       interprho = true;
       out.rho = rho;
   end
   
   if isempty(time)
       interptime = false;
       out.time = t_equinox';
   else
       interptime = true;
       out.time = time;
   end
   
   out.it=1:numel(out.time);
   out.ntime = numel(out.time);
   out.rho = rho;
   out.nrho = numel(out.rho);
   
   %% interpolate and map to RAPTOR grid
if interptime
    tind = find(t_equinox >= min(time) & t_equinox <= max(time));
end
   
for im=1:numel(map)
    mym = map{im};

    try
    equinoxdata = full(eval(mym{2}));
    
    try
        equinoxdata = full(eval(equinoxdata));
    end
    
    if length(equinoxdata(:,1)) ~= length(t_equinox)
        equinoxdata = 0.*t_equinox;
    end

    % interpolate to new t
    if interptime
        if size(equinoxdata,2)~=1
            data_on_time = interp1(t_equinox(tind),equinoxdata(tind,:),out.time,'linear',NaN)';
        else
            data_on_time = interp1(t_equinox(tind),equinoxdata(tind),out.time,'linear',NaN)';
        end
    else
        
        data_on_time = equinoxdata';
    end
   
    
    % if profile data
    if size(equinoxdata,2)==1 % only time
        out.(mym{1}) = data_on_time';
    else % profile data, interpolate on right rho
        if interprho
            out.(mym{1}) = interp1(r_equinox,data_on_time,out.rho);
        else
            out.(mym{1}) = data_on_time';
        end
    end
    
    catch err
        warning('could not interpolate %s to %s',mym{2}, mym{1});
        rethrow(err)
    end
end
    