function [yk,dh_dx,dh_du,Rk,sn] = diag_TCV_Vloop(~,xdotk1,gk,vk,~,RAPTORmodel)
%#codegen

%% Vloop %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% diagnostic parameters
scal = RAPTORmodel.psi.scal; % typical scale
sn   = 1e-3; % noise standard deviation

[upl,dupl_dx] = eval_psi(xdotk1,gk,vk,RAPTORmodel,false);
yk = upl(end); dyk_dx = dupl_dx(end,:);

% scaling matrix
T = 1/scal*eye(numel(yk));
%iT = scal*eye(numel(yk));

% h (scaled output value)
hk = T*yk; % scaled measured output

% dh_dx = dh_dxdot*dxdot_dx
dh_dx = T*dyk_dx;

% dh_du = dh_dxdot*dxdot_du
dh_du = T*zeros(numel(hk),RAPTORmodel.dims.nu); % TB: DUMMY! I NEED TO PROPERLY DEFINE THIS

% noise covariance
Rk = sn.^2*T*eye(numel(hk))*T';
return