%% Notes on how to get a CHEASE equilibrium in the right format from an EQDSK file
%
% First we need chease to be in the path
[stat,res] = system('which chease');
if stat~=0
    disp('CHEASE not found in path, exiting')
    return
end

assert(~~exist('run_chease','file'),'run_chease.m not found, CHEASEgui missing?');
assert(~~exist('find_cocos','file'),'find_cocos.m not found, some path is missing?');
%%
%% define an EQDSK file
eqfolder = fullfile('..','equils/chease');
fname_EQDSK = 'JET73442_EQDSK_60s_fromCRONOS';
fname_EQDSK_full = fullfile(eqfolder,fname_EQDSK);

% if you are unsure about COCOS, this function can tell you
cocos=find_cocos(fname_EQDSK_full);
disp(cocos);
mycocos = cocos(1); % pick one
%% run chease
disp('Running chease')
[fname_out,globalsvalues,namelist_struct,namelistfile_eff] = run_chease(2,fname_EQDSK_full,mycocos);
%% Convert output to .mat file for use in RAPTOR
% give eqdsk out name and o.....cols name to get chease_data
for ii=1:length(fname_out);
  if ~isempty(regexpi(fname_out{ii},['o.chease.' fname_EQDSK '$'] ,'start'))
    fname_ochease = fname_out{ii};
  end
  if ~isempty(regexpi(fname_out{ii},'o.*\.cols','start'))
    fname_ocols = fname_out{ii};
  end
  if ~isempty(regexpi(fname_out{ii},'o.*\.RZcols','start'))
    fname_oRZcols = fname_out{ii};
  end
  if ~isempty(regexpi(fname_out{ii},'EQDSK_COCOS_02_POS.OUT.*','start'))
    fname_eqdskout = fname_out{ii};
  end
end
% useful call to get chease results in local structure
[globalsvalues,ocols_struct] = extractdatachease(fname_ochease,fname_ocols,fname_oRZcols);

% save mat file with relevant cheasedata structures for RAPTOR
fname_matout = fullfile(eqfolder,'JET73442_60s_fromCRONOS.mat');
eqdsk_ocols_to_chease_data(fname_eqdskout,fname_ocols,fname_matout); 
    
