function [Mxa,Brxa,Bzxa,Cxa,Brpa,Bzpa,Cpa,na] = exgf(G,rp,zp)
% Function to obtain the Green's functions for magnetic field and flux
% quantities from poloidal field coil (E,F) currents from L.G structure.
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

na = numel(G.dima);
[rrx,zzx] = meshgrid(G.rx,G.zx);
% Obtain Green's functions
Mxa  = greenem('mut'  ,rrx,zzx,G.rw,G.zw)*G.Twa; % flux
Brxa = greenem('br'   ,rrx,zzx,G.rw,G.zw)*G.Twa; % radial B-field
Bzxa = greenem('bz'   ,rrx,zzx,G.rw,G.zw)*G.Twa; % vertical B-field
Cxa  = greenem('dbzdr',rrx,zzx,G.rw,G.zw)*G.Twa; % dB_z/dr
Brpa = greenem('br'   ,rp ,zp ,G.rw,G.zw)*G.Twa; % radial B-field
Bzpa = greenem('bz'   ,rp ,zp ,G.rw,G.zw)*G.Twa; % vertical B-field
Cpa  = greenem('dbzdr',rp ,zp ,G.rw,G.zw)*G.Twa; % dB_z/dr
end
