classdef test_mgams < matlab.unittest.TestCase
  % Test MGAMS GUI
  
  properties (TestParameter)
    action = {...
      'load',...
      'save',...
      'prepare',...
      'restore_prep_config',...
      'type',...
      'copy',...
      'paste',...
      'copyrampup',...
      'pasterampup',...
      'duplicate',...
      'rampdown',...
      'delete',...
      'interpolate',...
      'discretise',...
      'shift',...
      'scale',...
      'mirror',...
      'halfanalytic',...
      'analyticfit',...
      'setpoint',...
      'currentramp',...
      'setabsolutetime',...
      'setflattop',...
      'gascopy',...
      'gaspaste',...
      'gascopy_bd',...
      'gaspaste_bd',...
      'gasip',...
      'usefps',...
      'nofps',...
      'activate_dne',...
      'equil',...
      'var',...
      'grp',...
      'copyall',...
      'pastegrp',...
      };
%       'mouse'        % Would need mouse click simulation, perhaps later
%       'blank_recipe' % Only runs for the standard shot and tcv_oper
%       'quit'         % Tested as part of the TestMethodTeardown function
%       'modify'       % Pure callback method
  end

  methods(TestClassSetup)
    function working_folder_fixture(testCase)
      testCase.applyFixture(matlab.unittest.fixtures.WorkingFolderFixture);
    end
  end

  
  methods (TestMethodSetup)
    function init_mgams(testCase)
      testCase.addTeardown(@() mgams('quit'));
      mgams
    end
  end
  
  methods (Test,TestTags={'MGAMS','single_instance'})
    function test_mgams_gui_action(testCase,action)
      % Test each action, first goal is ensuring it runs without errors
      
      global MGerr
      
      testshot = num2str(mgu.mytestshot());
      
      % Start from testshot
      if ~ismember(action,{'save','load'})
        mgams('load',testshot);
      end
        
      switch action
%         case 'mouse'
        case 'load'
          mgams(action,'100000');
        case 'save'
          mgams('load','100000');
          %
          mgams(action,testshot);
        case 'prepare'
          mgams(action);
%         case 'blank_recipe'
        case 'restore_prep_config'
          mgams(action);
        case 'type'
          mgams(action);
%         case 'quit'
        case 'copy'
          mgams('equil',1);
          mgams(action,2);
        case 'paste'
          mgams('equil',1);
          mgams('copy',2);
          %
          mgams(action,NaN,0,NaN);
        case 'copyrampup'
          mgams('load','55555');
          %
          mgams(action,100);
        case 'pasterampup'
          mgams('load','55555');
          mgams('copyrampup',100);
          mgams('load',testshot);
          %
          mgams(action,100);
        case 'duplicate'
          mgams(action,2,NaN);
        case 'rampdown'
          mgams('load','55555');
          %
          mgams(action,0.5,0.8);
        case 'delete'
          mgams(action,1);
        case 'interpolate'
          mgams('equil',1);
          %
          mgams(action,2);
        case 'discretise'
          mgams('equil',1);
          %
          mgams(action,12)
        case 'shift'
          mgams('equil',1);
          %
          mgams(action,2,0.02,0);
        case 'scale'
          mgams('equil',1);
          %
          mgams(action,2,0.88,NaN,2);
        case 'mirror'
          mgams('equil',1);
          %
          mgams(action,2,0.88,NaN);
        case 'halfanalytic'
          mgams('equil',17);
          %
          mgams(action,0.25,NaN);
        case 'analyticfit'
          mgams('equil',17);
          %
          mgams(action,0.25,NaN);
        case 'setpoint'
          mgams('equil',17);
          %
          mgams(action,3,NaN,NaN); % Get
          %
          mgams(action,3,0.88,0); % Set
        case 'currentramp'
          mgams(action,3,7,100,500);
        case 'setabsolutetime'
          mgams('equil',17);
          %
          mgams(action,1.05);
        case 'setflattop'
          mgams('equil',13);
          %
          mgams(action);
        case 'gascopy'
          mgams('load','55555');
          %
          mgams(action);
        case 'gaspaste'
          mgams('load','55555');
          mgams('gascopy');
          mgams('load',testshot);
          %
          mgams(action);
          mgams('save',testshot);
        case 'gascopy_bd'
          mgams('load','55555');
          %
          mgams(action);
        case 'gaspaste_bd'
          mgams('load','55555');
          mgams('gascopy_bd');
          mgams('load',testshot);
          %
          mgams(action);
          mgams('save',testshot);
        case 'gasip'
          mgams(action,5);
        case 'usefps'
          mgams(action,0.33);
        case 'nofps'
          mgams(action);
        case 'activate_dne'
          mgams(action,0.1,7,30,0.1);
        case 'equil'
          mgams(action,10);
          %
          mgams(action,'next');
          %
          mgams(action,'previous');
          %
          mgams(action,'next10');
          %
          mgams(action,'previous10');
          %
          mgams(action,'select');
%         case 'modify'
        case 'var'
          mgams(action,1,1);
        case 'grp'
          mgams(action,1);
        case 'copyall'
          mgams(action);
        case 'pastegrp'
          mgams('load','55555');
          mgams('copyall');
          mgams('load',testshot);
          %
          mgams(action,2);
        otherwise
          testCase.assumeFail(sprintf('Tests for MGAMS action "%s" not implemented yet ...',action));
      end
      
      testCase.verifyEmpty(MGerr.message,sprintf('Some error has been triggered in MGAMS GUI:\n%s',MGerr.getReport()));
    end
  end

  
end
