% Matrix Generation Users
classdef mgu < mgc
 
 properties (Constant , Hidden)
  x = {
       -1     -1 'tcv_oper' ;
       -1     -1 'tcv_root' ;
        0  99999 ''         ;
   100000 100999 'tcv_oper' ;
   101000 101999 'blanchar' ;
   102000 102999 'gorno'    ;
   103000 103999 'ffelici'  ;
   104000 104999 'vallar'   ;
   105000 105999 'coda'     ;
   106000 106999 'theiler'  ;
   107000 107999 'duval'    ;
   108000 108999 'ech_oper' ;
   109000 109999 'reimerdes';
   110000 110999 'testa'    ;
   111000 111999 'carpita'  ;
   112000 112999 'sauter'   ;
   113000 113999 'usheikh'  ;
   114000 114999 'ofevrier' ;
   115000 115999 'lporte'   ;
   116000 116999 'labit'    ;
   117000 117999 'amerle'   ;
   118000 118999 'mylee'    ;
   119000 119999 'smarchio' ;
   120000 120999 'cwuethri' ;
   121000 122999 'gituser'  ; % Extended range for golden shot storage
   123000    Inf ''         };
 end
 
 methods (Static)
  
  function y = size
   y = size(mgu.x,1);
  end
  
  function y = shot1(k)
   y = mgu.x{k,1};
  end
  
  function y = shot2(k)
   y = mgu.x{k,2};
  end
  
  function y = user(k)
   y = mgu.x{k,3};
  end
  
  function y = check(shot)
   user = getenv('USER');
   for k = 1:mgu.size
    y = strcmp(user,mgu.user(k)) && mgu.shot1(k) <= shot && shot <= mgu.shot2(k);
    if y, break, end
   end
  end
  
  function y = listusers
    y = mgu.x(:,3);
  end
  
  function [shotrange] = userrange(user)
    kuser = find(strcmp(mgu.listusers,user));
    assert(numel(kuser)==1,'no unique user %s found in list',user);
    shotrange = {mgu.shot1(kuser),mgu.shot2(kuser)};
  end
  
  function [shotrange] = myrange()
    user = getenv('USER');
    shotrange = mgu.userrange(user);
  end
  
  function testshot = mytestshot()
    myshotrange = mgu.myrange();
    user = getenv('USER');
    if strcmp(user,'gituser')
      % Shot # based on MATLAB version
      A = str2double(regexp(version,'\d+','match'));
      testshot = myshotrange{end} - 1999 + mod(A(1)*100 + A(2),1000);
    else
      testshot = myshotrange{end}; % take last shot for this user
    end
  end
  
 end %methods
 
end %classdef
