function ism = ismgam(shot)
% ism = ismgam(shot)
% returns true if shot was prepared using mga.m
% false if used mga.f

% This is the list and order in which mga.m writes nodes
MGA_nodes = {    
    'AAASW'
    'AIPOFT'
    'AMLSW'
    'BZEROFT'
    'CAYREF'
    'EFCUR'
    'EFVOLT'
    'EFWAVE'
    'G1SW'
    'G2SW'
    'G3SW'
    'MIDPLAN'
    'OHCUR'
    'TOFT'
    'NTOFT'
    'TOH'
    'ZEREF'
};
n = numel(MGA_nodes);
[~,s] = mdsopen('PCS',shot);                             assert(logical(rem(s,2)),'error opening shot %d',shot);
[def,s] = mdsvalue('$DEFAULT');                          assert(logical(rem(s,2)), 'mds error shot %d',shot);
[~,s] = mdsvalue('TreeSetDefault("\\MGA")');             assert(logical(rem(s,2)), 'mds error shot %d',shot);
[t,s] = mdsvalue('getnci($1,"TIME_INSERTED")',MGA_nodes);assert(logical(rem(s,2)), 'mds error shot %d',shot);
% Some MDSplus bug caused times near round seconds to be off by 1s
% The whole MGA writing process should take under 0.01s, so we add or
% substract 1s to times further than 0.5s from the median time
tmed = median(t);
t(t-tmed>5e6) = t(t-tmed>5e6)-1e7;
t(tmed-t>5e6) = t(tmed-t>5e6)+1e7;
% Check order
o = isort(t);
ism = isequal(o,(1:n).');
[~,s] = mdsvalue('TreeSetDefault($1)',def);              assert(logical(rem(s,2)), 'mds error shot %d',shot);
end
