pro setup_refs,inscales,inoutputs,inamat_refs
 
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : SETUP_REFS.pro

; PURPOSE :
; Set up the reference drawables

; ARGUMENTS :
; scales		A-matrix output scales
; outputs		A-Matrix outputs
; amat_refs		Reference sources

; RESTRICTIONS :

; UPDATED/REASONS :
; Jo Lister	May 1993	Original
; M.J.Dutch	Mar 1995	Set limits for ALL CPs (incl. !xxx)
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

if ( n_elements(outputs) ne n_elements(scales)) then begin
  !tcvcs_error = 'SETUP REFS Bad Data'
  print,!tcvcs_error
  help
  return
endif

print,'SETUP REFS and PERTS in the A-Outputs and G2-Inputs '+!STIME

; first we set up the 32 vector of reference sources
refs = replicate('XXX',32)                                 

; render case-insensitive and extract the characters 00n for the wire number
outputs=strupcase(inoutputs)

; set limits for ALL specified references (including !xxx)
strindex = strmid(outputs,2,3)
index=fix(strindex)
refs(index-1)=inamat_refs                 
mds$put,'\pcs::load_wave_gen_b:refs','build_signal($,*,$)', $  
        refs,indgen(32)+1                                      

; now get rid of !xxx references
keep=where(strpos(outputs,'!') eq -1)
outputs = outputs(keep)
amat_refs = inamat_refs(keep)
scales = inscales(keep)

strindex = strmid(outputs,2,3)
index=fix(strindex)

ip_index = where(strpos(outputs,'IPLA') ne -1 and $        
         strpos(outputs,'ABS') eq -1)                      
ip_index = ip_index(0)                                         

; now we apply reasonable limits to the drawables
limits = scales * 10.0                                  
count=0
xxindex = where(amat_refs eq 'IP',count)
if(count gt 0) then limits(xxindex) =  $                            
      limits(xxindex)/scales(ip_index)  
nout = n_elements(outputs)

;for i=0,nout-1 do mds$put, $                                    
;        '\pcs::draw_refs:ref_'+strindex(i) $
;        +':limits','$',limits(i)*[-1,1]                         
;for i=0,nout-1 do mds$put, $                                    
;        '\pcs::draw_perts:pert_'+strindex(i) $            
;        +':limits','$',limits(i)*[-1,1]                

; which outputs are unused
absent 	= indgen(24)+1
absent(index-1)=0
count	= 0
ok	= where(absent ne 0,count)

; set any unused nodes off, and labels to inactive
if(count ne 0) then begin
 absent 	= iii(absent(ok))
 for i=0,n_elements(absent)-1 do begin
  mds$tcl,'set node \pcs::draw_refs:ref_'+absent(i)+' /off'
  mds$tcl,'set node \pcs::draw_perts:pert_'+absent(i)+' /off'
  mds$put,'\pcs::draw_refs:ref_'+absent(i)+':label','$','INACTIVE'
  mds$put,'\pcs::draw_perts:pert_'+absent(i)+':label','$','INACTIVE'
 endfor
endif

; set all used refs on, and setup the labels
for i=0,n_elements(outputs)-1 do begin
  mds$tcl,'set node \pcs::draw_refs:ref_'+strindex(i)+' /on'
  mds$tcl,'set node \pcs::draw_perts:pert_'+strindex(i)+' /on'
  mds$put,'\pcs::draw_refs:ref_'+strindex(i)+':label','$','REF_'+outputs(i)+ $
	' '+amat_refs(i)
  mds$put,'\pcs::draw_perts:pert_'+strindex(i)+':label','$','PERT_'+outputs(i) + $
	' '+amat_refs(i)
endfor

end
