pro mat_put,id,mat,mat_inputs,mat_outputs,mat_out_scale

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : MAT_PUT.pro

; PURPOSE :
; To load a physical matrix into the PCS tree

; ARGUMENTS :
; id			'A','G1-3','M'
; mat			Physical matrix
; mat_inputs		input list
; mat_outputs		output list
; mat_out_scale		output scales

; RESTRICTIONS :

; UPDATED/REASONS :
;	Jo Lister Oct 1992	Original
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; First check on the dimensions of the arguments
s_mat=size(mat)
s_in=size(mat_inputs)
s_out=size(mat_outputs)
s_scale=size(mat_out_scale)

if(s_mat(2) ne s_in(1)) or (s_mat(1) ne s_out(1)) or (s_mat(1) ne s_scale(1)) then begin
  print,'Mat_Put '+id+' Errors'
  help,mat,mat_inputs,mat_outputs,mat_out_scale
  !tcvcs_error='Mat_Put '+id+' Errors'
  return
endif

mds$put,'\pcs::phys_mat_'+id+'_inputs','$',mat_inputs
mds$put,'\pcs::phys_mat_'+id+'_outputs','$',mat_outputs
mds$put,'\pcs::phys_mat_'+id+'_out_scales','$',mat_out_scale
mds$put,'\pcs::phys_mat_'+id,'$',mat

end

