pro mat_overflow,shot,matrices

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : 

; PURPOSE :
; Takes the physics matrices, and looks at their statistics
; DYNAMIC RANGE and OVERFLOW CHECK

; ARGUMENTS :
; shot		shot for checking
; matrices	Matrices to be checked (default all)

; RESTRICTIONS :

; UPDATED/REASONS :
;	 Jo Lister October 1992
;	 M.J.Dutch   April 1995  Properly handle 3-D matrices (e.g. for matrix switching)
;-
; Controlled by :       Jo
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

pwint,'MAT_OVERFLOW   '+!stime
mds$open,'tcv_shot',shot

if(n_params() eq 1) then matrices = ['A1','A2','A3','G1','G2','G3','M']
matrices=[strupcase(matrices)]

for i=0,n_elements(matrices)-1 do begin

  counts = mds$value('\hybrid::mat_'+matrices(i)+':counts')
  count=0
  x =where(counts ge 4095 or counts le 0 , count)

  if(count ne 0) then begin
    !tcvcs_error='******** MAT_OVERFLOW Overflow indices '+matrices(i)
    pwint,!tcvcs_error
    xx = size(COUNTS)
    x = x(where(x ne -1))
    for j=0,n_elements(x)-1 do begin
      if (xx(0) eq 3) then i_mat = fix(x(j)/(xx(1)*xx(2))) else i_mat=0
      i_in = fix((x(j)-i_mat*xx(1)*xx(2))/xx(1))
      i_out = x(j)-i_in*xx(1)-i_mat*xx(1)*xx(2)
      out_name=' '
      in_name=' '
      a_cabling = mds$value('\hybrid::mat_a1_cabling')
      case matrices(i) of 
	'A1': in_name = ' '+a_cabling(i_in)
	'A2': in_name = ' '+a_cabling(i_in+48)
	'A3': in_name = ' '+a_cabling(i_in+96)
        else:
      endcase
      case matrices(i) of 
	'A1': out_name = ' '+mds$value('tcv_cp_name('+string(i_out+1)+')')
	'A2': out_name = ' '+mds$value('tcv_cp_name('+string(i_out+1)+')')
	'A3': out_name = ' '+mds$value('tcv_cp_name('+string(i_out+1)+')')
        else:
      endcase
      
      pwint,'Element ',fix(x(j)),' Value : ',fix(counts(x(j)))
      if (xx(0) eq 3) then pwint,' matrix(1:)',byte(i_mat+1),in_name
      pwint,'  input(1:)',byte(i_in+1),in_name
      pwint,' output(1:)',byte(i_out+1),out_name
    endfor

  endif

  number=0
  nvalid =  where((abs(counts-2048) gt 0.5),number)
  sigma = 0. & avg = 0.
  if(number gt 1) then sigma = stdev(counts(nvalid),avg)
  pwint,matrices(i),' Min/Max,Mean and s.d. ',min(counts),max(counts),avg,sigma

endfor

end
