pro mat_do,index,pcs_path

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : MAT_DO.pro

; PURPOSE :
; Takes the physics matrices, and puts them into the loadable matrices
; we sort the rows and columns into the right hardware positions
; we convert the MKSA units into physical gains (V/V)

; ARGUMENTS :
; index		Address of the matrix in the hybrid system

; RESTRICTIONS :

; UPDATED/REASONS :
; 	Jo Lister October 1992
; 	M.Dutch (5/3/93): bpol_AVG probes updated (use gains from sector 3)
; 	Jo Lister April 1993	Add output scales, PID scales and intermediate gains
; 	Jo Lister Dec 1993	Modify for new PCS
;	Jo Lister April 1994	Add fringes
;	Jo Lister Aug 1995	Cater for +- plasma currents
;	M.Dutch	  Aug 1996	Add the FPS (FAST) outscale
;				*** (should be a new node in hybrid tree, 
;				*** (but hardwired for now to -27.0 V/V
;				*** (actually depends on UDCref!!!!!!)
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

Print,'MAT_DO at index ',index,'  ',!stime

; add pcs_path argument (SC, 06/05/10)
if (not keyword_set(pcs_path)) then begin                       ;
  pcs_path='hybrid'
endif
pcs_path=strlowcase(pcs_path)

; #################################################  Prepare the A-matrix

; First we check whether the scale for Ip needs changing
; The voltage of channel 13 must be positive for the disruption detector
outscale = 	mds$value('\pcs::phys_mat_a_out_scales')
outputs = 	strupcase(mds$value('\pcs::phys_mat_a_outputs'))
ip_ref = 	mds$value('\pcs::draw_refs:ref_013')
ip_index = where(strpos(outputs,'013') ne -1) & ip_index=ip_index(0)
if (abs(min(ip_ref)) gt abs(max(ip_ref)) and outscale(ip_index) gt 0 or $
    abs(min(ip_ref)) lt abs(max(ip_ref)) and outscale(ip_index) lt 0) then begin
    outscale(ip_index)=-outscale(ip_index)
    mds$put,'\pcs::phys_mat_a_out_scales','$',outscale
    print,'Ip Outscale sign changed by MAT_DO to ',outscale(ip_index)
endif

inputs = 	mds$value('\pcs::phys_mat_a_inputs')
phys_mat = 	mds$value('\pcs::phys_mat_a')

; add the rogowski
add_rog,inputs,outputs,phys_mat

; add the ZIP
add_z,inputs,outputs,phys_mat

; add the FRINGES
add_fringes,inputs,outputs,phys_mat

; add the Bphi backoffs
add_backoffs,inputs,outputs,phys_mat

; add the offsets
add_offsets,inputs,outputs,phys_mat

; create the A-Matrix output list
outlist = 'CP'+iii(indgen(24)+1)

; compare the first 5 characters of the outputs, allowing use of the rest
outputs = strmid(outputs,0,5)

inlist = strupcase([mds$value('\hybrid::mat_a1:cabling'), $
		replicate('dummy for size',8)])

; calculate the inscale parameters
inscale = pcs_invgains(inputs)

; Store the A-Matrix input scales (YM - 1.2.2000)
mds$put,'\hybrid::mat_a_in_scale','$',inscale

mat_arrange,inputs,outputs,inscale,outscale,inlist,outlist,phys_mat,mat,'A',outs,in_indexa,out_indexa

; Store the A-Matrix output scales
mds$put,'\pcs::mat_a_out_scales','$',outs

; Here we can store the actual physical M-matrix used for the shot
mds$put,'\pcs::phys_mat_a','$',phys_mat
mds$put,'\pcs::phys_mat_a_inputs','$',inputs

; Now store the A-matrix in its loadable form
matsize=size(mat)
if (matsize(0) eq 3) then begin
  nmat = matsize(3)
  mds$put,'\pcs::load_mat_a1','$',mat(*,0:47,*)
  mds$put,'\pcs::load_mat_a2','$',mat(*,48:95,*)
  mds$put,'\pcs::load_mat_a3','$',mat(*,96:127,*)
endif else begin
  nmat=1
  mds$put,'\pcs::load_mat_a1','$',mat(*,0:47)
  mds$put,'\pcs::load_mat_a2','$',mat(*,48:95)
  mds$put,'\pcs::load_mat_a3','$',mat(*,96:127)
endelse

mat_indices=indgen(nmat)+index

mds$put,'\pcs::load_mat_a1_address','$',mat_indices
mds$put,'\pcs::load_mat_a2_address','$',mat_indices
mds$put,'\pcs::load_mat_a3_address','$',mat_indices

; #################################################  GAINS
out_gain = mds$value('\pcs::feed_gains')

; modify the A-matrix output scales for the gains
outscalea = outscale/out_gain

; ################################################### G1..G3 Matrices
inputs = 	outputs
inlist =  	[outlist,replicate('dummy for size',8)]

outlist = 'GO'+iii(indgen(24)+1)

; #### G1 

pid_gain = mds$value('\hybrid::pid_i')
;print,out_indexa
;print,pid_gain
pid_gain=pid_gain(out_indexa)
;print,pid_gain

inscale=replicate(0.0,n_elements(outscalea))
validgain=where(pid_gain ne 0.0)
if validgain(0) ne -1 then begin
  inscale(validgain) = outscalea(validgain) / pid_gain(validgain)
endif

outputs = 	strupcase(mds$value('\pcs::phys_mat_g1_outputs'))
outscale = 	mds$value('\pcs::phys_mat_g1_out_scales')
phys_mat = 	mds$value('\pcs::phys_mat_g1')

; compare the first 5 characters of the outputs, allowing use of the rest
outputs = strmid(outputs,0,5)

mat_arrange,inputs,outputs,inscale,outscale,inlist,outlist,phys_mat,mat,'G1',outs,in_indexg,out_indexg

matsize=size(mat)
if (matsize(0) eq 3) then nmat = matsize(3) else nmat=1
mat_indices=indgen(nmat)+index

mds$put,'\pcs::load_mat_g1','$',-mat
mds$put,'\pcs::load_mat_g1_address','$',mat_indices

; #### G2
pid_gain = mds$value('\hybrid::pid_p')
pid_gain=pid_gain(out_indexa)
inscale=replicate(0.0,n_elements(outscalea))
validgain=where(pid_gain ne 0.0)
if validgain(0) ne -1 then begin
  inscale(validgain) = outscalea(validgain) / pid_gain(validgain)
endif
;inscale = 	outscalea  / mds$value('\hybrid::pid_p')
outputs = 	strupcase(mds$value('\pcs::phys_mat_g2_outputs'))
outscale = 	mds$value('\pcs::phys_mat_g2_out_scales')
phys_mat = 	mds$value('\pcs::phys_mat_g2')

; compare the first 5 characters of the outputs, allowing use of the rest
outputs = strmid(outputs,0,5)

mat_arrange,inputs,outputs,inscale,outscale,inlist,outlist,phys_mat,mat,'G2',outs,in_indexg,out_indexg

matsize=size(mat)
if (matsize(0) eq 3) then nmat = matsize(3) else nmat=1
mat_indices=indgen(nmat)+index

mds$put,'\pcs::load_mat_g2','$',-mat
mds$put,'\pcs::load_mat_g2_address','$',mat_indices

; #### G3
pid_gain = mds$value('\hybrid::pid_d')
pid_gain=pid_gain(out_indexa)
inscale=replicate(0.0,n_elements(outscalea))
validgain=where(pid_gain ne 0.0)
if validgain(0) ne -1 then begin
  inscale(validgain) = outscalea(validgain) / pid_gain(validgain)
endif
;inscale = 	outscalea  / mds$value('\hybrid::pid_d')
outputs = 	strupcase(mds$value('\pcs::phys_mat_g3_outputs'))
outscale = 	mds$value('\pcs::phys_mat_g3_out_scales')
phys_mat = 	mds$value('\pcs::phys_mat_g3')

; compare the first 5 characters of the outputs, allowing use of the rest
outputs = strmid(outputs,0,5)

mat_arrange,inputs,outputs,inscale,outscale,inlist,outlist,phys_mat,mat,'G3',outs,in_indexg,out_indexg

matsize=size(mat)
if (matsize(0) eq 3) then nmat = matsize(3) else nmat=1
mat_indices=indgen(nmat)+index

mds$put,'\pcs::load_mat_g3','$',-mat
mds$put,'\pcs::load_mat_g3_address','$',mat_indices

outscaleg 	= outscale
outputsg	= outputs

; ################################################### M Matrix

inputs = 	mds$value('\pcs::phys_mat_m_inputs')
outputs = 	mds$value('\pcs::phys_mat_m_outputs')

; inlist et outlist sont tires d'un noeud au lieu d'etre ecrits en dur
; YM 1.2.2000
;inlist =  	strupcase([outlist(0:15), $			; 1st Input
;		 'ctlamp:ipol_e_'+iii(indgen(8)+1), $		; 2nd Input
;		 'ctlamp:ipol_f_'+iii(indgen(8)+1), $		
;		  outlist(16:19), $				; 3rd Input
;		 'ctlamp:ipol_oh_001','ctlamp:ipol_oh_002', $
;		  outlist(20:21), $
;		replicate('dummy for size',8)])
;outlist = 	['E_'+iii(indgen(8)+1),'F_'+iii(indgen(8)+1), $
;	  	 'OH_001','OH_002','GAS','FAST']
inlist  = strupcase([mds$value('\hybrid::mat_m_in_cabling'),$
		replicate('dummy for size',8)])
outlist = mds$value('\hybrid::mat_m_out_cabling')

if (pcs_path eq 'hybrid' or pcs_path eq 'rtdtacqden') then begin
; include the physical gains for the direct inputs
  inscale = pcs_invgains(inputs)
; add the gains for the inputs already there
  for i=0,n_elements(outputsg)-1 do begin
    inscale(where(inputs eq outputsg(i))) = outscaleg(i)
  endfor

  if (pcs_path eq 'rtdtacqden') then inscale(20)=1.

  

; fix the output scales : volts / volt
  e_volts   = mds$value('\hybrid::output_scales_e_u')
  f_volts   = mds$value('\hybrid::output_scales_f_u')
  oh_volts  = mds$value('\hybrid::output_scales_oh_u')
; 1 element de outscales provient maintenant d'un noeud (YM - 1.2.2000)
  outscalfastu=mds$value('\hybrid::output_scales_fast_u')
; RHVPS scales (SC, 05/09/06)
  rhvps_volts=[mds$value('product(\pcs::rhvps_gain_a[*, "PCS"], 0)'), $
             mds$value('product(\pcs::rhvps_gain_b[*, "PCS"], 0)'), $
             mds$value('product(\pcs::rhvps_gain_c[*, "PCS"], 0)')]
; ECRH mirror angle scales (SC, 15/02/07)
  outscalmirror=[1./mds$value('\pcs::mir_v_slope_01'),$
	       1./mds$value('\pcs::mir_v_slope_02'),$
	       1./mds$value('\pcs::mir_v_slope_03'),$
	       1./mds$value('\pcs::mir_v_slope_04'),$
	       1./mds$value('\pcs::mir_v_slope_05'),$
	       1./mds$value('\pcs::mir_v_slope_06')]

  outscales = [replicate(e_volts,8),replicate(f_volts,8),replicate(oh_volts,2),$
		1.0, outscalfastu, replicate(1.0,4)]
; Set up for RHVPS feedback experiment (SC, 01/11/06)
  outinda=where(outlist eq 'RHVPSA')
  outindb=where(outlist eq 'RHVPSB')
  if outinda(0) ne -1 then begin
    outscales(outinda(0))=rhvps_volts(0)
  endif
  if outindb(0) ne -1 then begin
    outscales(outindb(0))=rhvps_volts(1)
  endif

; Set up for ECRH mirror feedback experiment (SC, 15/02/07)
  outind1=where(outlist eq 'MIRROR1')
  outind2=where(outlist eq 'MIRROR2')
  outind3=where(outlist eq 'MIRROR3')
  outind4=where(outlist eq 'MIRROR4')
  outind5=where(outlist eq 'MIRROR5')
  outind6=where(outlist eq 'MIRROR6')
  if outind1(0) ne -1 then begin
    outscales(outind1(0))=outscalmirror(0)
  endif
  if outind2(0) ne -1 then begin
    outscales(outind2(0))=outscalmirror(1)
  endif
  if outind3(0) ne -1 then begin
    outscales(outind3(0))=outscalmirror(2)
  endif
  if outind4(0) ne -1 then begin
    outscales(outind4(0))=outscalmirror(3)
  endif
  if outind5(0) ne -1 then begin
    outscales(outind5(0))=outscalmirror(4)
  endif
  if outind6(0) ne -1 then begin
    outscales(outind6(0))=outscalmirror(5)
  endif

  outscale = fltarr(n_elements(outputs))
  for i=0,n_elements(outputs)-1 do begin
    outind=where(outputs(i) eq outlist)
    if outind(0) ne -1 then begin
      outscale(i)=outscales(outind(0))
    endif else begin
      outscale(i)=1.
    endelse
  endfor
  if (pcs_path eq 'rtdtacqden') then outscale(18)=1.

endif else if (pcs_path eq 'rtdtacq') then begin
  inscale = fltarr(n_elements(inputs))+1.0
; FPS scaling remains in hybrid system
  inscale(where(inputs eq 'GO022')) = outscaleg(where(outputsg eq 'GO022'))
  outscale = fltarr(n_elements(outputs))+1.0
  outscale(19)=mds$value('\hybrid::output_scales_fast_u')
endif
; 
; get the user's physical matrix
phys_mat = 	mds$value('\pcs::phys_mat_m')
if (pcs_path eq 'rtdtacq') then begin
; M matrix becomes an effective unit matrix for RT-controlled channels
 for j=1,21 do begin
  for i=1,19 do begin
   phys_mat(i-1,j-1)=0.
  endfor
 endfor
 for j=23,40 do begin
  for i=1,19 do begin
   phys_mat(i-1,j-1)=0.
  endfor
 endfor
 for i=1,18 do begin
  phys_mat(i-1,i-1)=1.
 endfor
 phys_mat(18,20)=1.
endif
if (pcs_path eq 'rtdtacqden') then phys_mat(18,20)=1.

mat_arrange,inputs,outputs,inscale,outscale,inlist,outlist,phys_mat,mat,'M',outs,in_indexm,out_indexm

matsize=size(mat)
if (matsize(0) eq 3) then nmat = matsize(3) else nmat=1
mat_indices=indgen(nmat)+index

; now we have the completed M-Matrix
mds$put,'\pcs::load_mat_m','$',mat
mds$put,'\pcs::load_mat_m_address','$',mat_indices

print,'MAT_DO ended at ',!stime
end
