pro magdb_iget,values,names

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : MAGDB_IGET.pro

; PURPOSE :
; returns a list of integer channels out of magdb

; ARGUMENTS :
; values	values found
; names		names found

; RESTRICTIONS :

; UPDATED/REASONS :
;	Jo Lister	July 92	Original
;-
; Controlled by :       Jo
;                       Michael
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

; get the offset into the magdb database
chix1 = vcs_chix('magdb::aaardvaaark')-1

; get the names and chixes out of the tree
mds$open,'tcv_shot',-1
names = mds$value('\vsystem::magdb_i:names')
chixes = mds$value('\vsystem::magdb_i:chixes')+chix1

; prepare for list call
val_array_desc=lonarr(2)
chix_array_desc = lonarr(2)

; go and fetch the gain codes as a list call
size = long(n_elements(chixes))*4
values = -chixes

if( not call_vms('vdb_accshr','vdb_pckdesc',val_array_desc,size,0,0,values))$
        then print,'Magdb failed pckdesc'
if( not call_vms('vdb_accshr','vdb_pckdesc',chix_array_desc,size,0,0,chixes))$
        then print,'Magdb failed chixes'
if( not call_vms('vdb_accshr','vdb_iget_list',chix_array_desc,val_array_desc))$
        then  begin
   if(n_elements(where(values+chixes eq 0)) gt 11) then begin
     print,'FATAL : MAGDB FAILS (probably arrays) = ', $
		n_elements(where(chixes+values eq 0))
     !tcvcs_error='Magdb failed list_iget'
     print,!tcvcs_error
     return
   endif
endif

names=strupcase(names)

end
