pro add_offsets,mat_inputs,mat_outputs,mat

; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$ TCVCS RECIPE ROUTINE

; This routine is part of the TCVCS Recipe concept.
; AS such, it must be guaranteed to have been tested.
; ALL modifications to this routine must be checked off
; on a new listing of the module.

;+ TCVCS FILE : ADD_OFFSETS.PRO

; PURPOSE :
; This routine takes an A-Matrix which is in terms of pure B and PSI
; It corrects A for offsets in the outputs, using the IPHI input

; ARGUMENTS :
; mat_inputs	Vector of A-Matrix input names
; mat_outputs	Vector of A-Matrix output names
; mat		A-Matrix

; RESTRICTIONS :

; UPDATED/REASON :
; 	Jo Lister 	Nov 98		Original
;-
; Controlled by :       Jo
; $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

print,'ADD OFFSETS ',!stime

mat_inputs 	= strupcase(mat_inputs)+'           '
mat_outputs 	= strupcase(mat_outputs)
nmat 	= n_elements(mat(0,0,*))

; locate the position of the IPHI input
iphi_input = 'CTLAMP:IPHI_001'
iphi_index = where(strtrim(mat_inputs) eq iphi_input)

; zip_offset
zip_input = 'CP012_ZIP'
zip_index = where(strtrim(mat_outputs) eq zip_input)

if(zip_index(0) eq -1) then begin
  print,'ZIP not found'
  return
endif

z_offset	= 2800.0
iphi		= 64000.0

print,'PRE  ',mat(zip_index,iphi_index),'  OFFSET: ',z_offset
mat(zip_index,iphi_index)	= mat(zip_index,iphi_index) - z_offset/iphi
print,'POST ',mat(zip_index,iphi_index)

end
