%VIZRMEX  Compute volume integrals
% [WP,FT0,VP] = VIZRMEX(FX,O,RY,IRY,RBT,DRX,DZX);
% Computes volume integrals on plasma grid from
% Inputs:
%  FX: F(z,r) plasma flux
%  O: Plasma mask grid
%  RY, IRY: Inner grid R and its inverse
%  RBT: vacuum R*BT
%  DRX, DZX: x grid spacing
% Outputs:
%  WP: Poloidal flux: \int_V B_p^2/2\mu0 dV
%  FT0: Enclosed toroidal flux from vacuum toroidal field: \int_S RB_{\phi0} drdz
%  VP: Plasma volume: \int_V dV
%
%  For details, see: [MEQ-redbook] 
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

function varargout = vizrmex(varargin)
 warning('MEQ:MEX "%s" not compiled or not in the Matlab path',mfilename)
 [varargout{1:nargout}] = vizrmexm(varargin{:});
end