function convert_to_2017a(mymodel)
% Function for converting Simulink files in previous version to 2017a version
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%%
release = Simulink.MDLInfo.getReleaseName(mymodel);

if ~strcmp(release,'R2019a')
  error('release must be R2019a, found %s',release);
end

origmodel = which(mymodel);
[filepath,name] = fileparts(origmodel);

model_2019 = fullfile(filepath,sprintf('%s_R2019a.slx',name));

fprintf('copy %s to %s\n',origmodel,model_2019)

assert(~unix(sprintf('cp %s %s',origmodel,model_2019)),'error copying');

fprintf('convert %s to 2017a\n',model_2019)

[~,name_2019] = fileparts(model_2019);
load_system(name_2019);
Simulink.exportToVersion(name_2019,origmodel,'R2017A_SLX');
close_system(name_2019,0); % close without saving