classdef visualization_tests < meq_test
	% Tests for MEQ visualizations
 %
 % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    t = 0:1e-4:5e-3
    tok = 'ana';
    shot = 11;
    verbosity = 1;
    L,LY;
  end
  
  properties(TestParameter)
    moviestyle = {'plain','fancy','full'}; % movie plotting styles
    plotFz = {true,false}; % plot extended contour in fancy plot or not
    vacuum = {true,false};
    plotArrows = {true,false};
  end
  
  methods (TestClassSetup,ParameterCombination='sequential')
    
    function run_code(testCase)
      s = rng(1);
      testCase.addTeardown(@() rng(s));
      
      [L,LX] = fge(testCase.tok,testCase.shot,testCase.t,...
        'selu','e','nu',30,'izgrid',true,'ivacuum',true,'ifield',true);
      LX.Va(:) = 0; LY = fget(L,LX);
      testCase.L = L; testCase.LY = LY; %#ok<*PROP>
    end
  end
  
  methods (Test,TestTags={'Integration'})
    function test_meqplots(testCase,plotFz,vacuum,plotArrows)
      % test various ways of running meqplotfancy();
      L = testCase.L; LY = testCase.LY; %#ok<*PROPLC>
         
      % normal fancy plot
      clf;
      meqplotfancy(L,meqxk(LY,1),...
        'plotFz',plotFz,'vacuum',vacuum,'plotArrows',plotArrows);
      
      % fancy plot without plasma
      clf;
      meqplotfancy(L);
      
      clf;
      meqcompare(L,meqxk(LY,1),meqxk(LY,1));

      clf
      meqplotevo(L,LY);
      
      clf
      fgeploteig(L);
    end
    
    function test_fbtplot(testCase)
      %%
      [L,LX,LY] = fbt(testCase.tok,testCase.shot,1,...
        'selu','e','nu',30);
      hax=fbtplot(L,LX,LY);
      testCase.assertTrue(isa(hax,'handle'));
    end
      
    function test_meqplots_vacuum(testCase)
      L = testCase.L; LY = meqxk(testCase.LY,1); %#ok<*PROPLC>

      L.G = meqg(L.G,L.P,'Brxa','Brxu','Bzxa','Bzxu');
      % Fx,B fields from external conductors
      LY.Fx  = reshape(L.G.Mxa*LY.Ia  + L.G.Mxu*LY.Iu,L.nzx,L.nrx);
      LY.Brx = reshape(L.G.Brxa*LY.Ia + L.G.Brxu*LY.Iu,L.nzx,L.nrx);
      LY.Bzx = reshape(L.G.Bzxa*LY.Ia + L.G.Brxu*LY.Iu,L.nzx,L.nrx);

      % vacuum field
      clf;
      meqplotfield(L,LY,'FxLevels',[-1:0.1:1],...
        'plotArrows',true,'plotBp',true,'BpLevels',[0:0.02:0.2]);
      
    end
    
    function test_meqmovie(testCase,moviestyle)
      % test movie generation
      fname = 'test-movie';
      isfancy = isequal(moviestyle,'fancy');
      dosave = isfancy; % save only fancy one
      clf;
      fname_out = meqmovie(testCase.L,testCase.LY,...
        'decimate',5,'style',moviestyle,'dosave',dosave,'filename',fname);
      if dosave, delete(fname_out); end
    end
  end
end
