classdef (SharedTestFixtures={mexm_fixture}) uata_test < meq_test
  % tests of uatamex
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    tol = 1e-6; % numerical tolerance (for single precision!)
    seed = 0; % randomizer seed
  end
  
  properties (TestParameter)
    n = {'1','2','3','4','5','6','7','8'}; % matrix size for uata
    type = {'single','double'}; % datatype for uata
    method = {'uatamex','uatamexm'};
  end
  
  methods (TestClassSetup)
    function setRandomSeed(testCase)
      rng(testCase.seed); % to always get same 'random' numbers;
    end
  end
  
  methods(Test, TestTags = {'Unit'})
    function test_iata(testCase,n,type,method)
      %% Tests for uata(A) - packed storage of A.'*A
      n = str2double(n);
      
      % set up typical matrices
      A1 = cast(randn(76,n),type); % size [nr x nj]
      A2 = cast(randn(2,n),type);  % size [ni x nj]
      A=A1'*A1; uA = A(triu(true(n)));
      
      uAmex = feval(method,A1);
      testCase.verifyLessThan(norm(uAmex-uA)/norm(uA),testCase.tol, 'uatamex(A1) result failure');
      
      A=A2'*A2;uA = A(triu(true(n)));
      
      uAmex = feval(method,A2);
      testCase.verifyLessThan(norm(uAmex-uA)/norm(uA),testCase.tol, 'uatamex(A2) result failure');

      %%
    end
  end
end
