classdef test_timing_performance < meq_test
  % Tests of timing performance
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  methods (Test,TestTags={'Integration'})
    
    function test_anamak_timing(testCase)
      %% Test timing performance for anamak fge case
      time = 0:1e-3:0.1;
      tok = 'ana';
      
      tL = tic;
      [L] = fge(tok,1,time,'cde','cde0Dss','agcon',{'Ip','bp','qA'},...
        'usepreconditioner',true);
      tLe = toc(tL);
      
      tX = tic;
      LX = fgex(tok,time,L);
      tLXe = toc(tX);
      
      tl = tic;
      L = fgel(L,meqxk(LX,1));
      tLle = toc(tl);
      
      tY = tic;
      LY = fget(L,LX);
      tLYe = toc(tY);
      
      tTot = toc(tL);
      
      fprintf('time for L  :%2.2fs\n',tLe);
      fprintf('time for LX :%2.2fs\n',tLXe);
      fprintf('time for lin:%2.2fs\n',tLle);
      fprintf('time for LY :%2.2fs\n',tLYe);
      fprintf('Total:      :%2.2fs\n',tTot);

      testCase.assertTrue(~isempty(LY),'FGE did not converge');
    end
  end
end