classdef (SharedTestFixtures={meq_fixture,meqscripts_fixture}) ...
    test_repro_Ohm_model < matlab.unittest.TestCase
  % test of the reprocess_Ohm_model function
  %
  % [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  properties
    shot = 69194; % One of TCV standard shot
    tstart = 0.1;
    tend = 0.4;
    dt = 5e-3;
    doplot = true;
  end
  
  methods (Test, TestTags = {'fge'})
    function test_running(testCase)
      % Compute equilibrium reconstruction
      [L,LX,LY] = liuqe(testCase.shot,testCase.tstart:testCase.dt:testCase.tend);
      % Test running the reprocess function
      LY = reprocess_Ohm_model(L,LY, 'doplot', testCase.doplot);
    end
  end
end


